/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  <p>This class can be used to track the mouse position as it moves along a trace.</p>
 *  <p>Here is a screenshot, where the ChartCrossHair is shown in red:</p>
 *  <img src="doc-files/ChartCrossHair-1.png" alt="ChartCrossHair Screenshot"/>
 *  <p>When the model property is not set, the class tracks the nearest point from all available models.
 *  When the model property is set, the points are limited to points from that model.</p>
 *  <p>Note: This class used to be called <code>ChartValueFocus</code> but was renamed to avoid 
 *  overloading the term focus</p>
 *  @see ChartValueReporter
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class ChartCrossHair implements java.awt.event.MouseListener, java.awt.event.MouseMotionListener, java.awt.event.ComponentListener, com.jidesoft.chart.Drawable {

	/**
	 *  The <code>propertyName</code> of the <code>PropertyChangeEvent</code> that is fired when the <em>color</em> property changes
	 */
	public static final String PROPERTY_COLOR = "Color";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the <em>chart</em> property changes
	 */
	public static final String PROPERTY_CHART = "Chart";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the <em>circleDiameter</em> property changes
	 */
	public static final String PROPERTY_CIRCLE_DIAMETER = "Circle Diameter";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the <em>model</em> property changes
	 */
	public static final String PROPERTY_MODEL = "Model";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the (read-only) <em>observedModel</em> property changes
	 */
	public static final String PROPERTY_OBSERVED_MODEL = "Model Observed";

	/**
	 *  The property name of the PropertyChangeEvent that is fired when the position of the cross hair changes.
	 *  This may be more interesting when the snapToPoints property is true.
	 */
	public static final String PROPERTY_POSITION = "Position";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the <em>snapToPoints</em> property changes.
	 */
	public static final String PROPERTY_SNAP_TO_POINTS = "Snap to Points";

	/**
	 *  The property name of the PropertyChangeEvent that is fired when the <em>Stroke</em> property changes.
	 */
	public static final String PROPERTY_STROKE = "Stroke";

	/**
	 *  The property name of the PropertyChangeEvent that is fired when the <em>UpdateFromModel</em> property changes.
	 */
	public static final String PROPERTY_UPDATE_FROM_MODEL = "Update From Model";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the (read-only) <em>visible</em> property changes
	 */
	public static final String PROPERTY_VISIBLE = "Visible";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the visibility of the horizontal
	 *  line changes
	 */
	public static final String PROPERTY_HORIZONTAL_LINE_VISIBLE = "Horizontal Line Visible";

	/**
	 *  The <code>propertyName</code> of the PropertyChangeEvent that is fired when the visibility of the vertical
	 *  line changes
	 */
	public static final String PROPERTY_VERTICAL_LINE_VISIBLE = "Vertical Line Visible";

	/**
	 *  Default constructor provided mainly for compatibility with Java bean pattern.
	 *  It is expected that you would usually pass in a chart object to the constructor
	 *  since you cannot use this class without telling the instance which chart object it should be applied to.
	 */
	public ChartCrossHair() {
	}

	/**
	 *  Create a new ChartCrossHair instance for use with the supplied chart.
	 *  @param chart the Chart instance for which we wish to create a cross hair
	 */
	public ChartCrossHair(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Creates a new ChartCrossHair instance for use with the supplied chart.
	 *  If autoRegister is true, it also registers itself as a MouseListener and a MouseMotionListener on the
	 *  chart, as well as adding itself as a Drawable. It is very common to perform these operations
	 *  immediately after creating the ChartCrossHair so the ChartCrossHair class offers this as a convenience.
	 *  @param chart the chart instance for which we wish to create a CrossHair
	 *  @param autoRegister whether we wish to auto-register the CrossHair as a listener on the chart.
	 */
	public ChartCrossHair(com.jidesoft.chart.Chart chart, boolean autoRegister) {
	}

	public void detach() {
	}

	/**
	 *  Add a property change listener to this object. You might do this for instance to discover when the
	 *  <code>ChartModel</code> that is under the cross hair changes.
	 *  @param listener the PropertyChangeListener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove a previously-added listener 
	 *  @param listener the PropertyChangeListener to remove
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns the chart object this class operates with
	 *  @return a chart object
	 */
	public com.jidesoft.chart.Chart getChart() {
	}

	/**
	 *  Specify the chart object on which the cross hair operates
	 *  @param chart the chart object
	 */
	public void setChart(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Returns the flag to indicate whether a vertical line is drawn as part of the cross hair
	 *  @return whether a vertical line is drawn as part of the cross hair
	 */
	public boolean isVerticalLineVisible() {
	}

	/**
	 *  Specify whether a vertical line should be drawn as part of the cross hair
	 *  @param verticalLineVisible whether the line is visible
	 */
	public void setVerticalLineVisible(boolean verticalLineVisible) {
	}

	/**
	 *  Returns the flag to indicate whether a horizontal line is drawn as part of the cross hair
	 *  @return whether a horizontal line is drawn as part of the cross hair
	 */
	public boolean isHorizontalLineVisible() {
	}

	/**
	 *  Specify whether a horizontal line should be drawn as part of the cross hair
	 *  @param horizontalLineVisible whether the line is visible
	 */
	public void setHorizontalLineVisible(boolean horizontalLineVisible) {
	}

	/**
	 *  Returns a value indicating whether the cross hair is allowed to assume a position between adjacent data points
	 *  of a model (false) or 'snap' to genuine points (true).
	 *  @return a boolean to indicate whether the <em>snapToPoints</em> property is set.
	 */
	public boolean isSnapToPoints() {
	}

	/**
	 *  Specify whether the cross hair should 'snap' to known data points. If this is not set the cross hair
	 *  is allowed to assume a position on the straight line path between adjacent points of a model.
	 *  @param snapToPoints the new value of the snapToPoints property
	 */
	public void setSnapToPoints(boolean snapToPoints) {
	}

	/**
	 *  Returns the value of the updateFromModel property
	 *  @return the value of the updateFromModel property
	 */
	public boolean isUpdateFromModel() {
	}

	/**
	 *  Specify whether the position of the cross hair is dependent on one or more models in the chart.
	 *  If set to false you can set the position of the cross hair independently.
	 *  @param updateFromModel the new value of the updateFromModel property
	 */
	public void setUpdateFromModel(boolean updateFromModel) {
	}

	/**
	 *  Returns the stroke currently used for the horizontal and vertical line of the cross hair
	 *  @return the Stroke currently used for the horizontal and vertical line of the cross hair
	 */
	public java.awt.Stroke getStroke() {
	}

	/**
	 *  Specify the stroke to use for the horizontal and vertical lines of the cross hair
	 *  @param stroke the stroke to use for the horizontal and vertical line of the cross hair
	 */
	public void setStroke(java.awt.Stroke stroke) {
	}

	/**
	 *  Returns the pixel point for (x, 0). This is useful when working out where to draw the cross hair.
	 *  @return the pixel point for (x, 0)
	 */
	public java.awt.Point getXAxisPoint() {
	}

	/**
	 *  Returns the pixel point for (y, 0). This is useful when working out where to draw the cross hair.
	 *  @return the pixel point for (y, 0)
	 */
	public java.awt.Point getYAxisPoint() {
	}

	/**
	 *  Not used
	 */
	public void mouseClicked(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Not used
	 */
	public void mousePressed(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Not used
	 */
	public void mouseReleased(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Recognises a change in the mouse position under dragging
	 */
	public void mouseDragged(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Makes the visible property true when the mouse enters the chart
	 */
	public void mouseEntered(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Makes the visible property false when the mouse exits the chart
	 */
	public void mouseExited(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Recognises a change in the mouse position
	 */
	public void mouseMoved(java.awt.event.MouseEvent e) {
	}

	@java.lang.Override
	public void componentResized(java.awt.event.ComponentEvent e) {
	}

	@java.lang.Override
	public void componentMoved(java.awt.event.ComponentEvent e) {
	}

	@java.lang.Override
	public void componentShown(java.awt.event.ComponentEvent e) {
	}

	@java.lang.Override
	public void componentHidden(java.awt.event.ComponentEvent e) {
	}

	/**
	 *  Returns the model of interest, if any. Note that this may be different from the observed model.
	 *  @return the model of interest, if any
	 */
	public com.jidesoft.chart.model.ChartModel getModel() {
	}

	/**
	 *  If you set the model of the ChartValueReporter, then only points from that model will be reported.
	 *  Otherwise points from the nearest model will be reported.
	 *  @param model the model from which points should be reported
	 */
	public void setModel(com.jidesoft.chart.model.ChartModel model) {
	}

	/**
	 *  The color used for the cross hair
	 *  @return the color used for the cross hair
	 */
	public java.awt.Color getColor() {
	}

	/**
	 *  Set the color to use for the cross hair
	 *  @param color the new color to use
	 */
	public void setColor(java.awt.Color color) {
	}

	/**
	 *  This is a read-only property that allows you to find out which model the cross hair is
	 *  currently pointing at.
	 *  @return the ChartModel under the cross hair
	 */
	public com.jidesoft.chart.model.ChartModel getObservedModel() {
	}

	/**
	 *  Update the cross hair using the latest known cursor position.
	 *  You should not need to call this method directly.
	 */
	public void update() {
	}

	/**
	 *  Enables you to set the position of the ChartCrossHair programmatically
	 *  @param chartable the position of the cross hair in user coordinates
	 */
	public void setPosition(com.jidesoft.chart.model.Chartable chartable) {
	}

	/**
	 *  Returns the position of the cross hair in user coordinates
	 *  @return the position of the cross hair in user coordinates
	 */
	public com.jidesoft.chart.model.Chartable getPosition() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void draw(java.awt.Graphics g) {
	}

	/**
	 *  The diameter of the circle that is used for locating the position of the cross hair
	 *  @return the diameter of the circle used for the centre of the cross hair
	 */
	public int getCircleDiameter() {
	}

	/**
	 *  Sets the diameter of the circle to use for the centre of the cross hair
	 *  @param circleDiameter given in pixels
	 */
	public void setCircleDiameter(int circleDiameter) {
	}
}
