/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  A class that can pan a chart, but provides no UI to do so. Instead, this class may be called
 *  by other UI elements - in particular it is used by the MouseDragPanner class.
 * 
 *  You will probably not need to use this class directly, but may wish to do so on occasions
 *  if you have alternative GUI elements in your user-interface that should drive chart panning.
 * 
 *  <p> As a user of this class, you can find out when a pan has occurred by registering as a
 *  <code>PanListener</code> </p>
 */
public class ChartPanner {

	public ChartPanner(com.jidesoft.chart.Chart chart) {
	}

	public ChartPanner(com.jidesoft.chart.Chart chart, boolean horizontalPan, boolean verticalPan) {
	}

	public boolean isHorizontalPan() {
	}

	public void setHorizontalPan(boolean horizontalPan) {
	}

	public boolean isVerticalPan() {
	}

	public void setVerticalPan(boolean verticalPan) {
	}

	/**
	 *  Returns a boolean to indicate whether the pan is continuous.
	 *  @return a boolean to indicate whether the pan is continuous.
	 */
	public boolean isContinuous() {
	}

	/**
	 *  Specify whether the pan is continuous. A continuous pan is one where the chart continues to pan
	 *  after you have released the mouse. It gives the effect of momentum to the drag, and is subject
	 *  to a friction coefficient.
	 *  @param continuous whether the pan should be continuous
	 */
	public void setContinuous(boolean continuous) {
	}

	public void resetSpeeds() {
	}

	/**
	 *  Returns the current friction coefficient, used with the continuous panning feature
	 *  @return the current friction coefficient
	 */
	public double getFrictionCoefficient() {
	}

	/**
	 *  Specify the friction coefficient used with the continuous panning feature.
	 *  The friction coefficient is a number between 0 and 1 (default 0.1). The higher the value, the
	 *  more friction and the quicker the chart will come to a halt when panned.
	 *  @param friction the friction coefficient
	 */
	public void setFrictionCoefficient(double friction) {
	}

	/**
	 *  Register an object's interest in pan events
	 *  @param listener the object interested in pan events
	 */
	public void addPanListener(PanListener listener) {
	}

	/**
	 *  De-register an object's interest in pan events
	 *  @param listener the object no longer interested in pan events
	 */
	public void removePanListener(PanListener listener) {
	}

	protected void firePan() {
	}

	protected void firePan(int xOffset, int yOffset) {
	}

	protected void firePan(PanEvent event) {
	}

	public <any> getXLimits() {
	}

	public void setXLimits(<any> xLimits) {
	}

	public <any> getYLimits() {
	}

	public void setYLimits(<any> yLimits) {
	}

	public void drag(java.awt.Point dragStart, java.awt.Point dragEnd) {
	}
}
