/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  A common parent class for SelectionZoomEvents and PointZoomEvents
 *  @see ZoomDirection
 */
public abstract class ChartSelectionEvent extends java.util.EventObject {

	/**
	 *  Create a ChartSelectionEvent
	 *  @param source the source of the event
	 */
	public ChartSelectionEvent(Object source) {
	}

	/**
	 *  Returns a value to indicate whether the zoom was <code>IN</code> or <code>OUT</code>.
	 *  @return the direction of zoom
	 */
	public abstract ZoomDirection getDirection() {
	}

	/**
	 *  Returns the location of the zoom
	 *  @return the zoom location
	 */
	public abstract Object getLocation() {
	}
}
