/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  <p>A ChartValueReporter shows the position of the 'focus' point as x and y coordinates.
 *  ChartValueReporter supports numeric and time axes. To display a formatted string for a time axis,
 *  use something like the following: </p>
 *  <pre>chartValueReporter.setFormatString("x = %1$tH:%1$tM; y = %2$.3f");</pre>
 *  <p>
 *  This displays the hours and minutes of the time on the x axis, along with a numeric value for the
 *  y axis, given to 3 decimal places.
 *  </p>
 *  @see java.util.Formatter
 */
public class ChartValueReporter extends javax.swing.JPanel implements java.awt.event.MouseListener, java.awt.event.MouseMotionListener {

	/**
	 *  Constructs a ChartValueReporter that reports the value around the cursor point of the supplied chart.
	 *  <p>
	 *  When you use this constructor, you will need to register the instance as a MouseListener and a
	 *  MouseMotionListener on the chart
	 *  </p>
	 *  @param newChart the Chart instance for which we wish to create a ChartValueReporter
	 */
	public ChartValueReporter(com.jidesoft.chart.Chart newChart) {
	}

	/**
	 *  This constructor acknowledges the fact that a ChartValueReporter is often used in conjunction with a CrossHair.
	 *  As the CrossHair will already need to be registered as a MouseListener and a MouseMotionListener on the
	 *  chart, it is more efficient for the reporter to listen to property changes on the CrossHair to decide
	 *  when it needs to be updated. (This is especially the case when the crossHair has the SnapToPoints
	 *  property set to true.) The constructor auto-registers the instance as a listener on the CrossHair,
	 *  so you don't have to do it.
	 *  @param crossHair the crossHair that is being used on the chart of interest.
	 */
	public ChartValueReporter(ChartCrossHair crossHair) {
	}

	/**
	 *  Clears the reported value and resets the last known cursor position.
	 */
	protected void clearChartValue() {
	}

	/**
	 *  Updates the reported value with the supplied x and y coordinates
	 *  @param x the x value in user coordinate space
	 *  @param y the y value in user coordinate space
	 */
	protected void updateChartValue(double x, double y) {
	}

	/**
	 *  Sets the text of the ChartValueReporter to be the specified value
	 *  @param text the updated text to display
	 */
	protected void setText(String text) {
	}

	/**
	 *  Returns the format string used for reporting the current value in the chart
	 *  @return the format string
	 */
	public String getFormatString() {
	}

	/**
	 *  Sets the format string used for displaying the current chart value.
	 *  The string used should be suitable for displaying two floating point values. For example, it could be
	 *  "x = %.3f, y = %.3f"
	 *  @param formatString the format string to use
	 */
	public void setFormatString(String formatString) {
	}

	/**
	 *  Returns the text used when there is no point selected and no chart value to report
	 *  @return the text used when there is no selection in the corresponding chart
	 */
	public String getNoSelectionText() {
	}

	/**
	 *  Set the text to use when no point is selected and there is no chart value to report.
	 *  @param noSelectionText the text to use when no point is selected
	 */
	public void setNoSelectionText(String noSelectionText) {
	}

	/**
	 *  Returns the x coordinate (in user coordinates) of the current chart value
	 *  @return the x coordinate
	 */
	public Double getChartX() {
	}

	/**
	 *  Returns the y coordinate (in user coordinates) of the current chart value
	 *  @return the y coordinate
	 */
	public Double getChartY() {
	}

	/**
	 *  Not used
	 */
	public void mouseClicked(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Not used
	 */
	public void mousePressed(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Not used
	 */
	public void mouseReleased(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Not used
	 */
	public void mouseDragged(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Not used
	 */
	public void mouseEntered(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Clears the reported value when the mouse exits the chart
	 */
	public void mouseExited(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Updates the reported value when the mouse moves 
	 */
	public void mouseMoved(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Returns the model of interest, if any
	 *  @return the model of interest
	 */
	public com.jidesoft.chart.model.ChartModel getModel() {
	}

	/**
	 *  If you set the model of the <code>ChartValueReporter</code>, then only points from that 
	 *  model will be reported. Otherwise points from the nearest model will be reported.
	 *  @param model the model from which points should be reported
	 */
	public void setModel(com.jidesoft.chart.model.ChartModel model) {
	}

	/**
	 *  Update the reported value using the latest known cursor position.
	 *  You should not need to call this method directly.
	 */
	public void update() {
	}
}
