/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  A MouseListener and MouseMotionListener that effects a pan by changing the ranges of the supplied Chart's axes when
 *  the mouse is dragged. 
 *  <p> As a user of this class, you can find out when a pan has occurred by registering as a
 *  <code>PanListener</code> </p>
 *  
 *  <p>This class also supports <i>continuous panning</i>, which means that the chart continues
 *  to move even after you have finished with the drag. A friction coefficient is applied to slow it down and eventually
 *  stop it. It gives the user the impression that the chart has momentum when you drag it.</p> 
 */
public class MouseDragPanner implements MouseHandler {

	public static final String PROPERTY_HORIZONTAL_PAN = "Pan Horizontal";

	public static final String PROPERTY_VERTICAL_PAN = "Pan Vertical";

	public static final String PROPERTY_X_LIMITS = "X Limits";

	public static final String PROPERTY_Y_LIMITS = "Y Limits";

	/**
	 *  Create a MouseDragPanner on the supplied chart that pans in both directions.
	 *  @param chart the chart we want to pan
	 */
	public MouseDragPanner(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Create a MouseDragPanner on the supplied chart that pans in the specified directions.
	 *  @param chart the chart we want to be able to pan
	 *  @param panHorizontally whether the user is able to pan in the horizontal direction
	 *  @param panVertically whether the user is able to pan in the vertical direction
	 */
	public MouseDragPanner(com.jidesoft.chart.Chart chart, boolean panHorizontally, boolean panVertically) {
	}

	/**
	 *  Register interest in the properties of this class
	 *  @param listener the object to be notified of property changes
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  De-register interest in the properties of this class
	 *  @param listener the object to removed as a property change listener
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Is panning allowed in the horizontal direction?
	 *  @return a boolean to indicate whether horizontal panning is allowed
	 */
	public boolean isHorizontalPan() {
	}

	/**
	 *  Specify whether to allow horizontal panning
	 *  @param horizontalPan the new value for the horizontalPan property
	 */
	public void setHorizontalPan(boolean horizontalPan) {
	}

	/**
	 *  Is panning allowed in the vertical direction?
	 *  @return a boolean to indicate whether vertical panning is allowed
	 */
	public boolean isVerticalPan() {
	}

	/**
	 *  Specify whether to allow vertical panning
	 *  @param verticalPan the new value for the verticalPan property
	 */
	public void setVerticalPan(boolean verticalPan) {
	}

	/**
	 *  Returns the Cursor that is shown while the chart canvas is being dragged
	 *  @return the Cursor that is shown while the chart canvas is being dragged
	 */
	public java.awt.Cursor getDragCursor() {
	}

	/**
	 *  Provide the facility to customise the cursor that is shown while the chart canvas
	 *  is being dragged
	 *  @param dragCursor the Cursor to show while the chart canvas is being dragged
	 */
	public void setDragCursor(java.awt.Cursor dragCursor) {
	}

	/**
	 *  Returns a boolean to indicate whether the cursor is to change while the chart canvas is being dragged
	 *  @return a boolean to indicate whether the cursor is to change
	 */
	public boolean isChangeCursorWhileDragging() {
	}

	/**
	 *  Specify whether the cursor should change while the chart canvas is being dragged. Default is true.
	 *  @param changeCursorWhileDragging whether to change the canvas while dragging the chart
	 */
	public void setChangeCursorWhileDragging(boolean changeCursorWhileDragging) {
	}

	/**
	 *  Returns a boolean to indicate whether the pan is continuous.
	 *  @return a boolean to indicate whether the pan is continuous.
	 */
	public boolean isContinuous() {
	}

	/**
	 *  Specify whether the pan is continuous. A continuous pan is one where the chart continues to pan
	 *  after you have released the mouse. It gives the effect of momentum to the drag, and is subject 
	 *  to a friction coefficient.
	 *  @param continuous whether the pan should be continuous
	 */
	public void setContinuous(boolean continuous) {
	}

	/**
	 *  Returns the current friction coefficient, used with the continuous panning feature
	 *  @return the current friction coefficient
	 */
	public double getFrictionCoefficient() {
	}

	/**
	 *  Returns the mask value used to check whether a mouse button is pressed
	 *  @return the mask value used to check whether a mouse button is pressed
	 */
	public int getButtonMask() {
	}

	/**
	 *  Specify the mask that is used to test whether a mouse button has been pressed.
	 *  By default only the left mouse button is checked, but you can change this so that the middle and right
	 *  mouse buttons are also checked by using the value
	 *  <pre>
	 *      InputEvent.BUTTON1_MASK | InputEvent.BUTTON2_MASK | InputEvent.BUTTON3_MASK
	 *  </pre>
	 *  @param buttonMask a mask value used for checking whether a mouse button is pressed
	 */
	public void setButtonMask(int buttonMask) {
	}

	/**
	 *  Specify the friction coefficient used with the continuous panning feature.
	 *  The friction coefficient is a number between 0 and 1 (default 0.1). The higher the value, the
	 *  more friction and the quicker the chart will come to a halt when panned.
	 *  @param friction the friction coefficient
	 */
	public void setFrictionCoefficient(double friction) {
	}

	/**
	 *  Returns the current limits for panning in the x direction
	 *  @return the limits for panning in the x direction
	 */
	public <any> getXLimits() {
	}

	/**
	 *  Specify the limits in the x direction beyond which panning is not allowed
	 *  @param xPanLimits the minimum and maximum possible x value under panning
	 */
	public void setXLimits(<any> xPanLimits) {
	}

	/**
	 *  Returns the current limits for panning in the y direction
	 *  @return the limits for panning in the y direction
	 */
	public <any> getYLimits() {
	}

	/**
	 *  Specify the limits in the y direction beyond which panning is not allowed
	 *  @param yPanLimits the minimum and maximum possible y value under panning
	 */
	public void setYLimits(<any> yPanLimits) {
	}

	/**
	 *  Register an object's interest in pan events
	 *  @param listener the object interested in pan events
	 */
	public void addPanListener(PanListener listener) {
	}

	/**
	 *  De-register an object's interest in pan events
	 *  @param listener the object no longer interested in pan events
	 */
	public void removePanListener(PanListener listener) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mousePressed(java.awt.event.MouseEvent e) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseReleased(java.awt.event.MouseEvent e) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseClicked(java.awt.event.MouseEvent event) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseEntered(java.awt.event.MouseEvent event) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseExited(java.awt.event.MouseEvent event) {
	}

	/**
	 *   Receive a mouseDrag gesture and interpret it as a pan
	 */
	public void mouseDragged(java.awt.event.MouseEvent e) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseMoved(java.awt.event.MouseEvent event) {
	}

	/**
	 *  If this returns true, the handler has consumed the event.
	 */
	public boolean isHandled() {
	}

	/**
	 *  Specify whether the handler has handled the event
	 */
	public void setHandled(boolean handled) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseWheelMoved(java.awt.event.MouseWheelEvent e) {
	}
}
