/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  The idea of this class is to make it possible to combine the effect of multiple mouse handlers. Individual mouse
 *  handlers need to implement the MouseListener and MouseMotionListener interfaces, as well as provide the additional
 *  methods defined by <code>MouseHandler</code>. <p> The handlers are added to an instance of this class in the order
 *  in which they should be invoked. If a handler has dealt with the event then it should set its handled property to be
 *  true so that no further handlers will be notified of the event; otherwise the same event will be passed to all the
 *  known handlers for processing. </p>
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class MouseEventManager implements java.awt.event.MouseListener, java.awt.event.MouseMotionListener, java.awt.event.MouseWheelListener {

	public MouseEventManager() {
	}

	/**
	 *  Adds a handler to the list of maintained handlers and returns this instance so that invocations can be chained.
	 * 
	 *  @param handler the handler to add
	 *  @return this instance
	 */
	public MouseEventManager addHandler(MouseHandler handler) {
	}

	public void removeHandler(MouseHandler handler) {
	}

	public void mouseClicked(java.awt.event.MouseEvent e) {
	}

	public void mouseEntered(java.awt.event.MouseEvent e) {
	}

	public void mouseExited(java.awt.event.MouseEvent e) {
	}

	public void mousePressed(java.awt.event.MouseEvent e) {
	}

	public void mouseReleased(java.awt.event.MouseEvent e) {
	}

	public void mouseDragged(java.awt.event.MouseEvent e) {
	}

	public void mouseMoved(java.awt.event.MouseEvent e) {
	}

	public void mouseWheelMoved(java.awt.event.MouseWheelEvent e) {
	}
}
