/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  An interface implemented by mouse event handler objects.
 */
public interface MouseHandler extends java.awt.event.MouseListener, java.awt.event.MouseMotionListener, java.awt.event.MouseWheelListener {

	/**
	 *  Set a flag to indicate whether the class actually handled the event. If not the event
	 *  can passed on to the next handler in the chain; otherwise it will be consumed and not
	 *  passed on further.
	 *  @param handled whether the event was handled
	 */
	public void setHandled(boolean handled);

	/**
	 *  You can read the property to see whether an event was handled
	 *  @return whether the event was handled
	 */
	public boolean isHandled();
}
