/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  Used for controlling zooming on a Chart component using the mouse wheel.
 */
public class MouseWheelZoomer implements MouseHandler, java.awt.event.MouseWheelListener {

	public static final String PROPERTY_HORIZONTAL_ZOOM = "Horizontal Zoom";

	public static final String PROPERTY_VERTICAL_ZOOM = "Vertical Zoom";

	public static final String PROPERTY_ZOOM_LOCATION = "Zoom Location";

	public static final String PROPERTY_X_LIMITS = "X Limits";

	public static final String PROPERTY_MIN_X_RANGE_SIZE = "Min X Range Size";

	public static final String PROPERTY_MAX_X_RANGE_SIZE = "Max X Range Size";

	public static final String PROPERTY_Y_LIMITS = "Y Limits";

	public static final String PROPERTY_MIN_Y_RANGE_SIZE = "Min Y Range Size";

	public static final String PROPERTY_MAX_Y_RANGE_SIZE = "Max y Range Size";

	/**
	 *  Create a zooming facility and apply it to both the X and Y axes of the
	 *  supplied Chart component.
	 * 
	 *  @param chart the chart to which the zoomer corresponds
	 */
	public MouseWheelZoomer(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Use of this constructor allows you to specify a zoom that is on just one
	 *  of the two axes. (You could have a zoom on neither, but what is the point
	 *  of that?)
	 * 
	 *  @param chart         the Chart instance to which the zoomer should be added
	 *  @param zoomHorizontally whether horizontal zooming should be allowed
	 *  @param zoomVertically   whether vertical zooming should be allowed
	 */
	public MouseWheelZoomer(com.jidesoft.chart.Chart chart, boolean zoomHorizontally, boolean zoomVertically) {
	}

	/**
	 *  Registers an object that is interested in property changes on this instance
	 *  @param listener the object to be notified of changes
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  De-registers an object that is no longer interested in property changes on this instance
	 *  @param listener the object that is no longer interested in property changes
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns a boolean to indicate whether zoom is being supported in the horizontal direction
	 * 
	 *  @return whether horizontal zoom is active
	 */
	public boolean isHorizontalZoom() {
	}

	/**
	 *  Specify whether the horizontal zoom is active
	 * 
	 *  @param horizontalZoom a boolean to indicate whether a zoom should occur on the
	 *                        horizontal axis
	 */
	public void setHorizontalZoom(boolean horizontalZoom) {
	}

	/**
	 *  Returns a boolean to indicate whether zoom is being supported in the vertical direction
	 * 
	 *  @return whether vertical zoom is active
	 */
	public boolean isVerticalZoom() {
	}

	/**
	 *  Specify whether the vertical zoom is active
	 * 
	 *  @param verticalZoom a boolean to indicate whether a zoom should occur on the
	 *                      vertical axis
	 */
	public void setVerticalZoom(boolean verticalZoom) {
	}

	/**
	 *  Returns the location used as the origin of a zoom
	 * 
	 *  @return the location of the origin of a zoom event
	 */
	public ZoomLocation getZoomLocation() {
	}

	/**
	 *  Specify the location that will be the origin of a zoom. By default this is the center of the chart.
	 * 
	 *  @param zoomLocation the origin of a zoom
	 */
	public void setZoomLocation(ZoomLocation zoomLocation) {
	}

	public java.awt.geom.Point2D getZoomFrom() {
	}

	public void setZoomFrom(java.awt.geom.Point2D zoomFrom) {
	}

	/**
	 *  Returns the current outer limits for the x axis under zooming
	 *  @return the current outer limits for the x axis under zooming
	 */
	public <any> getXLimits() {
	}

	/**
	 *  Specify the outer limits of the x axis under zooming
	 *  @param xOuterLimits the outer limits of the x axis
	 */
	public void setXLimits(<any> xOuterLimits) {
	}

	/**
	 *  Returns the minimum range size for user coordinates in the x direction
	 *  @return the minimum range size for user coordinates in the x direction
	 */
	public Double getMinXRangeSize() {
	}

	/**
	 *  Specifies the minimum range size for user coordinates in the x direction.
	 *  Used to limit zooming in on a chart to the given level of resolution.
	 */
	public void setMinXRangeSize(Double minXRangeSize) {
	}

	/**
	 *  Returns the current outer limits of the y axis under zooming
	 *  @return the current outer limits of the y axis under zooming
	 */
	public <any> getYLimits() {
	}

	/**
	 *  Specifies the outer limits of the y axis under zooming
	 *  @param yOuterLimits the outer limits of the y axis
	 */
	public void setYLimits(<any> yOuterLimits) {
	}

	/**
	 *  Returns the minimum range size for user coordinates in the y direction
	 *  @return the minimum range size for user coordinates in the y direction
	 */
	public Double getMinYRangeSize() {
	}

	/**
	 *  Specifies the minimum range size for user coordinates in the y direction.
	 *  Used to limit zooming in on a chart to the given level of resolution.
	 */
	public void setMinYRangeSize(Double minYRangeSize) {
	}

	/**
	 *  Returns the maximum range size for user coordinates in the x direction
	 *  @return the maximum range size for user coordinates in the x direction
	 */
	public Double getMaxXRangeSize() {
	}

	/**
	 *  Specifies the maximum range size for user coordinates in the x direction
	 *  Used to prevent zooming out too far on a chart
	 *  @param maxXRangeSize the maximum size of the x range
	 */
	public void setMaxXRangeSize(Double maxXRangeSize) {
	}

	/**
	 *  Returns the maximum range size for user coordinates in the y direction
	 *  @return the maximum range size for user coordinates in the y direction
	 */
	public Double getMaxYRangeSize() {
	}

	/**
	 *  Specifies the maximum range size for user coordinates in the y direction.
	 *  Used to prevent zooming out too far on a chart
	 *  @param maxYRangeSize the maximum size of the y range
	 */
	public void setMaxYRangeSize(Double maxYRangeSize) {
	}

	/**
	 *  Register an object that is interested in zoom events
	 * 
	 *  @param listener the object to be notified of zoom events
	 */
	public void addZoomListener(ZoomListener listener) {
	}

	/**
	 *  Remove an object that is registered to receive zoom events
	 * 
	 *  @param listener the listener to remove
	 */
	public void removeZoomListener(ZoomListener listener) {
	}

	/**
	 *  Fire a zoom event to inform listeners of a zoom
	 * 
	 *  @param zoomPoint the point at which the zoom occurred
	 *  @param direction the direction of the zoom
	 */
	protected void fireZoom(java.awt.Point zoomPoint, ZoomDirection direction) {
	}

	/**
	 *  Fire a zoom event to inform listeners of a zoom
	 * 
	 *  @param zoomPoint  the point at which the zoom occurred
	 *  @param direction  the direction of the zoom
	 *  @param zoomFactor the multiplication factor applied for the zoom
	 */
	protected void fireZoom(java.awt.Point zoomPoint, ZoomDirection direction, double zoomFactor) {
	}

	protected void fireZoom(ChartSelectionEvent zoomEvent) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseDragged(java.awt.event.MouseEvent event) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseMoved(java.awt.event.MouseEvent event) {
	}

	/**
	 *  An important method that handles the behaviour when the mouse wheel moved.
	 */
	public void mouseWheelMoved(java.awt.event.MouseWheelEvent event) {
	}

	/**
	 *  Indicates whether an event that was received by this listener was handled
	 */
	public boolean isHandled() {
	}

	/**
	 *  Specify whether an event that was received by this listener was handled
	 */
	public void setHandled(boolean handled) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseClicked(java.awt.event.MouseEvent e) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseEntered(java.awt.event.MouseEvent e) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseExited(java.awt.event.MouseEvent e) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mousePressed(java.awt.event.MouseEvent e) {
	}

	/**
	 *  One of the methods of the MouseHandler interface
	 */
	public void mouseReleased(java.awt.event.MouseEvent e) {
	}
}
