/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  An <code>EventObject</code> generated while panning.
 */
public class PanEvent extends java.util.EventObject {

	/**
	 *  Create a PanEvent object using the supplied parameter as the source of the event
	 *  @param source the source of the event
	 */
	public PanEvent(Object source) {
	}

	/**
	 *  Create a PanEvent object using the supplied object parameter as the source of the event
	 *  and also noting the size of the pan as x and y pixels offsets
	 *  @param source the source of the event
	 *  @param xOffset the x offset of the pan event
	 *  @param yOffset the y offset of the pan event
	 */
	public PanEvent(Object source, int xOffset, int yOffset) {
	}

	/**
	 *  Returns the x offset of the pan event
	 *  @return the x offset, or null if it was not set
	 */
	public Integer getXOffset() {
	}

	/**
	 *  Returns the y offset of the pan event
	 *  @return the y offset, or null if it was not set
	 */
	public Integer getYOffset() {
	}
}
