/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  <p>Note that this class has best performance when the ChartModel being used is a DefaultChartModel,
 *  as the DefaultChartModel is efficient at keeping track of its x and y ranges. For other kinds of ChartModel
 *  the class will only really work well when the levels of data are small.</p>
 */
public class PanIndicator implements com.jidesoft.chart.Drawable {

	/**
	 *  Create a PanIndicator for the supplied chart by placing it with the supplied Placement.
	 *  The placement indicates not only where it is on the chart but also the direction that it points to data if
	 *  data in that direction is not currently visible.
	 *  @param chart the chart on which this indicator will be used
	 *  @param placement where to place the indicator
	 */
	public PanIndicator(com.jidesoft.chart.Chart chart, PanIndicator.Placement placement) {
	}

	/**
	 *  The method of the drawable interface that actually draws the arrow
	 */
	public void draw(java.awt.Graphics g) {
	}

	public static final class Placement {


		public static final PanIndicator.Placement LEFT;

		public static final PanIndicator.Placement RIGHT;

		public static final PanIndicator.Placement TOP;

		public static final PanIndicator.Placement BOTTOM;

		public static PanIndicator.Placement[] values() {
		}

		public static PanIndicator.Placement valueOf(String name) {
		}
	}
}
