/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  This class listens to mouse movements and draws 'rubber band' selections when
 *  added to an instance of Chart.
 *  <p>
 *  A ChartSelectionEvent is fired when the mouse button is released.</p>
 *  <p>You can use property settings to constrain the shape of the rectangular region used for the zoom.
 *  Essentially there are four modes:
 *  <dl>
 *    <dt>Free</dt>
 *      <dd>The user can drag out any rectangle and the shape is unconstrained. This is the default setting.</dd>
 *    <dt>Proportional</dt>
 *      <dd>The shape of the rectangle is constrained to be the same 
 *    (i.e. <em>similar</em> in the mathematical sense) as the shape of the chart. To use this mode, set 
 *       keepWidthHeightRatio to true and leave zoomOrientation with its default value of BOTH.
 *    <dt>Horizontal</dt>
 *      <dd>The user can only zoom in horizontally, so the zoom area is a vertical bar. To use this mode, set
 *      zoomOrientation to HORIZONTAL.</dd>
 *    <dt>Vertical</dt>
 *      <dd>The user can only zoom in vertically, so the zoom area is a horizontal bar. To use this mode, set
 *      zoomOrientation to VERTICAL.</dd>
 *  </dl>
 *  
 *  @author Simon White (swhite@catalysoft.com)
 */
public class RubberBandZoomer implements com.jidesoft.chart.Drawable, java.awt.event.MouseMotionListener, java.awt.event.MouseListener {

	public static final String PROPERTY_OUTLINE_STROKE = "Rubber Band Outline Stroke";

	public static final String PROPERTY_OUTLINE_COLOR = "Rubber Band Outline Color";

	public static final String PROPERTY_FILL = "Rubber Band Fill";

	public static final String PROPERTY_KEEP_RATIO = "Rubber Band Keep Ratio";

	public static final String PROPERTY_ZOOM_ORIENTATION = "Zoom Orientation";

	public RubberBandZoomer(javax.swing.JComponent component) {
	}

	/**
	 *  Add a listener that is informed when properties change
	 *  
	 *  @param listener
	 *             the property change listener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove a property change that was added previously
	 *  
	 *  @param listener
	 *             the listener to remove
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Add a listener that is informed when the user wishes to zoom in or out
	 *  
	 *  @param listener the listener to be informed of the zoom
	 */
	public void addZoomListener(ZoomListener listener) {
	}

	/**
	 *  Remove a listener that was previously added
	 *  
	 *  @param listener the listener to be informed of the zoom
	 */
	public void removeZoomListener(ZoomListener listener) {
	}

	/**
	 *  Specify the outline stroke to use for the rubber band
	 *  
	 *  @param stroke
	 *             the Stroke to use
	 */
	public void setOutlineStroke(java.awt.Stroke stroke) {
	}

	/**
	 *  @return the current outline stroke
	 */
	public java.awt.Stroke getOutlineStroke() {
	}

	/**
	 *  Specify the color to use for the outline of the rubber band
	 *  
	 *  @param color the color to use for the outline
	 */
	public void setOutlineColor(java.awt.Color color) {
	}

	/**
	 *  @return the fill used for the rectangular inner region of the rubber band
	 */
	public java.awt.Paint getFill() {
	}

	/**
	 *  Specify the fill for the inner region of the rubber band. Set this to
	 *  null if you don't want any fill at all.
	 *  
	 *  @param fill
	 *             the fill to use
	 */
	public void setFill(java.awt.Paint fill) {
	}

	public boolean isKeepWidthHeightRatio() {
	}

	public void setKeepWidthHeightRatio(boolean keepWidthHeightRatio) {
	}

	public ZoomOrientation getZoomOrientation() {
	}

	public void setZoomOrientation(ZoomOrientation zoomOrientation) {
	}

	protected void fireZoomIn(java.awt.Rectangle selection) {
	}

	protected void fireZoomOut(java.awt.Point p) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void mouseClicked(java.awt.event.MouseEvent e) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void mouseEntered(java.awt.event.MouseEvent e) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void mouseExited(java.awt.event.MouseEvent e) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void mousePressed(java.awt.event.MouseEvent e) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void mouseReleased(java.awt.event.MouseEvent e) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void mouseDragged(java.awt.event.MouseEvent e) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void mouseMoved(java.awt.event.MouseEvent e) {
	}

	public void draw(java.awt.Graphics g) {
	}
}
