/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  Indicates whether a zoom is "into" or "out of" the object of interest.
 *  
 *  @see MouseWheelZoomer
 */
public final class ZoomDirection extends Enum {

	/**
	 *  This constant indicates that a zoom is 'into' the chart, so the area around the zoom origin will become bigger.
	 */
	public static final ZoomDirection IN;

	/**
	 *  This constant indicates that a zoom is 'out of' the chart, so the area around the zoom origin will become smaller.
	 */
	public static final ZoomDirection OUT;

	public static ZoomDirection[] values() {
	}

	public static ZoomDirection valueOf(String name) {
	}
}
