/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  Used to indicate the origin of the zoom as a property in a MouseWheelZoomer.
 *  
 *  @see MouseWheelZoomer
 */
public final class ZoomLocation extends Enum {

	/**
	 *  Use this as a value to zoom from the centre of the chart
	 */
	public static final ZoomLocation CHART_CENTER;

	/**
	 *  Use this as a value to zoom from the position of the mouse cursor
	 */
	public static final ZoomLocation MOUSE_CURSOR;

	/**
	 *  Opt to zoom from a specified point that can be set as a property on the zoomer instance
	 */
	public static final ZoomLocation SPECIFIED_POINT;

	public static ZoomLocation[] values() {
	}

	public static ZoomLocation valueOf(String name) {
	}
}
