/**
 *  Contains classes to support interpolation of chart models, either for aesthetics or for better approximations of functions.
 */
package com.jidesoft.chart.fit;


/**
 *  The idea is to provide a class that, given a chart model and an x or y
 *  value, can read off the corresponding value from the other axis. This assumes straight lines to join up
 *  consecutive points in the chart model.
 */
public class FunctionMap {

	public FunctionMap() {
	}

	/**
	 *  Returns the first point at which the line x = xIn crosses any of the line segments joining consecutive points of
	 *  the chart model
	 * 
	 *  @param model the ChartModel of interest
	 *  @param yIn   the supplied y value
	 *  @return the approximate X value corresponding to the supplied Y value
	 * 
	 *  @throws ChartException
	 */
	public static double getXApproximately(com.jidesoft.chart.model.ChartModel model, double yIn) {
	}

	/**
	 *  Returns the first point at which the line x = xIn crosses any of the line segments joining consecutive points of
	 *  the chart model
	 * 
	 *  @param model the model in which we are finding x values
	 *  @param yIn the y value of interest
	 *  @return the approximate X values corresponding to the given y value
	 * 
	 *  @throws BelowBoundsException
	 *  @throws AboveBoundsException
	 */
	public static java.util.List getXsApproximately(com.jidesoft.chart.model.ChartModel model, double yIn) {
	}

	/**
	 *  Returns all the points at which x = xIn crosses any of the line segments joining consecutive points of the chart
	 *  model
	 * 
	 *  @param model the chart model in which we are finding y values
	 *  @param xIn the x value of interest
	 *  @return the approximate y values corresponding to the given x value
	 * 
	 *  @throws BelowBoundsException
	 *  @throws AboveBoundsException
	 */
	public static java.util.List getYsApproximately(com.jidesoft.chart.model.ChartModel model, double xIn) {
	}

	/**
	 *  Returns the first point at which the line x = xIn crosses any of the line segments joining consecutive points of
	 *  the chart model
	 * 
	 *  @param model the chart model in which we are finding a y value
	 *  @param xIn the x value of interest
	 *  @return the approximate Y value corresponding to the supplied x value
	 * 
	 *  @throws BelowBoundsException
	 *  @throws AboveBoundsException
	 */
	public static double getYApproximately(com.jidesoft.chart.model.ChartModel model, double xIn) {
	}
}
