/**
 *  Contains classes to support interpolation of chart models, either for aesthetics or for better approximations of functions.
 */
package com.jidesoft.chart.fit;


/**
 *  Uses Ordinary Least Squares regression to fit a line to a data set
 * 
 *  @see <a href="http://en.wikipedia.org/wiki/Simple_linear_regression">Wikipedia on Simple Linear Regression</a>
 */
public class LineFitter implements CurveFitter {

	/**
	 *  Creates and returns an instance of this class if one does not already exist; otherwise simply return the instance that already exists.
	 * 
	 *  @return a LineFitter instance
	 */
	public static LineFitter getInstance() {
	}

	/**
	 *  Performs linear regression on a ChartModel and returns a <code>ChartModel</code> that encodes the line
	 * 
	 *  @param model the ChartModel to approximate with a line
	 *  @return a new ChartModel with two points defining the line of the regression
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel performRegression(String name, com.jidesoft.chart.model.ChartModel model, <any> xRange, int numPoints) {
	}

	/**
	 *  <p>Creates a ChartModel for describing a line from a Polynomial instance. The model will be assigned a default name.</p> <p><b>Note:</b> the Polynomial is expected to be a line but the method does not check this assumption.</p>
	 * 
	 *  @param line      the line that the new model should describe
	 *  @param xRange    the range over which the line segment should be given
	 *  @param numPoints ignored for linear models
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel createModel(Polynomial line, <any> xRange, int numPoints) {
	}

	/**
	 *  <p>Creates a ChartModel for describing a line from a Polynomial instance.</p> <p><b>Note:</b> the Polynomial is expected to be a line but the method does not check this assumption.</p>
	 * 
	 *  @param name      the name of the new model
	 *  @param line      the line that the new model should describe
	 *  @param xRange    the range over which the line segment should be given
	 *  @param numPoints ignored for linear models
	 *  @return a ChartModel to approximate the supplied polynomial
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel createModel(String name, Polynomial line, <any> xRange, int numPoints) {
	}

	/**
	 *  Creates a model for describing the given polynomial by generating points along the curve.
	 * 
	 *  @param name       the name of the model to create
	 *  @param polynomial the polynomial describing the curve
	 *  @param xs         the x points for which values of y should be calculated
	 *  @return a new ChartModel instance containing the calculated points
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel createModel(String name, Polynomial polynomial, Double[] xs) {
	}

	/**
	 *  Performs linear regression on a ChartModel and returns a <code>Line</code>
	 * 
	 *  @param model the ChartModel on which to perform linear regression
	 *  @return a line summarising the supplied ChartModel
	 */
	public Polynomial performRegression(com.jidesoft.chart.model.ChartModel model) {
	}

	/**
	 *  Performs linear regression on a collection of points and returns a Polynomial
	 * 
	 *  @param points the points
	 *  @return a linear Polynomial that approximates and summarises the points
	 */
	public Polynomial performRegression(java.util.Collection points) {
	}
}
