/**
 *  Contains classes to support interpolation of chart models, either for aesthetics or for better approximations of functions.
 */
package com.jidesoft.chart.fit;


/**
 *  <p>This class represents a polynomial of any number of terms (provided the powers of x are all positive integers).</p>
 *  <p>So, for example an instance of this class can be used to represent an expression such as <i>x</i>&nbsp;-&nbsp;5 or
 *  3<i>x</i><sup>2</sup>&nbsp;+&nbsp;4<i>x</i>&nbsp;+&nbsp;2</p>
 */
public class Polynomial {

	/**
	 *  Create a polynomial using the supplied coefficients for successive powers of x starting from a constant.
	 *  Therefore for 2x+4, supply the arguments [4, 2].
	 * 
	 *  @param coefficients the coefficients of the successive terms of the polynomial
	 */
	public Polynomial(Double[] coefficients) {
	}

	/**
	 *  Create a polynomial using the supplied coefficients for successive powers of x starting from a constant.
	 *  Therefore for 2x+4, create as <code>new Polynomial(4, 2)</code>.
	 * 
	 *  @param coefficients the coefficients of the successive terms of the polynomial
	 */
	public Polynomial(double[] coefficients) {
	}

	/**
	 *  Returns the coefficients of the polynomials, lowest term (i.e. the constant) first
	 * 
	 *  @return the coefficients of the polynomial
	 */
	public java.util.List getCoefficients() {
	}

	/**
	 *  Returns the coefficient of the polynomial with the given index. The constant has index of 0.
	 * 
	 *  @param index the index of the coefficient; the constant term has zero index.
	 *  @return the coefficient of the term indicated
	 */
	public Double getCoefficient(int index) {
	}

	/**
	 *  Specify the coefficients of the polynomial
	 * 
	 *  @param coefficients the coefficients, given as a <code>List</code> of <code>Double</code>s
	 */
	public void setCoefficients(java.util.List coefficients) {
	}

	/**
	 *  Specify the coefficients of the polynomial
	 * 
	 *  @param coefficients the coefficients, given as an array of <code>Double</code>s
	 */
	public void setCoefficients(Double[] coefficients) {
	}

	/**
	 *  Compute the value of the polynomial for a given x value. This works by starting at the coefficient of the highest
	 *  order term and iteratively multiplying by x and adding the coefficient of the next lower term.
	 * 
	 *  @param x the x value to plug into the expression
	 *  @return the value of the polynomial for the given x value.
	 */
	public double eval(double x) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
