/**
 *  Contains classes to support interpolation of chart models, either for aesthetics or for better approximations of functions.
 */
package com.jidesoft.chart.fit;


/**
 *  A class for fitting a polynomial to a set of data provided as a ChartModel. The order of the polynomial to be
 *  fitted is given as a parameter to the constructor.
 */
public class PolynomialFitter implements CurveFitter {

	/**
	 *  Create a class that can derive a best-fit polynomial of order <em>n</em> for a ChartModel. For example, to create
	 *  straight lines, use an order of 1 and for quadratic curves use an order of 2.
	 *  @param n the order of the polynomial
	 */
	public PolynomialFitter(int n) {
	}

	/**
	 *  Specify the order of the polynomial to create when performing regression.
	 *  @param n the order of polynomials to create
	 */
	public void setOrder(int n) {
	}

	/**
	 *  Start by creating a RealMatrix to store the coefficients double[][] coefficientsData = {{2, 3, -2}, {-1, 7, 6},
	 *  {4, -3, -5}}; RealMatrix coefficients = new RealMatrixImpl(coefficientsData);
	 *  <p/>
	 *  Next create a double[] array to represent the constant vector and use solve(double[]) to solve the system
	 *  double[] constants = {1, -2, 1}; double[] solution = coefficients.solve(constants);
	 * 
	 *  @param model the chart model on which to perform the regression
	 *  @return a Polynomial representing the result of the regression
	 */
	public Polynomial performRegression(com.jidesoft.chart.model.ChartModel model) {
	}

	/**
	 *  Start by creating a RealMatrix to store the coefficients double[][] coefficientsData = {{2, 3, -2}, {-1, 7, 6},
	 *  {4, -3, -5}}; RealMatrix coefficients = new RealMatrixImpl(coefficientsData);
	 *  <p/>
	 *  Next create a double[] array to represent the constant vector and use solve(double[]) to solve the system
	 *  double[] constants = {1, -2, 1}; double[] solution = coefficients.solve(constants);
	 * 
	 *  @param model the chart model on which to perform the regression
	 *  @return a ChartModel created from <code>numPoints</code> points, and representing the result of the regression.
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel performRegression(String name, com.jidesoft.chart.model.ChartModel model, <any> xRange, int numPoints) {
	}

	/**
	 *  Create a ChartModel by sampling from the supplied polynomial. The sample consists of <code>numPoints</code>
	 *  points, distributed evenly over <code>xRange</code>
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel createModel(Polynomial polynomial, <any> xRange, int numPoints) {
	}

	/**
	 *  Create a named ChartModel by sampling from the supplied polynomial. The sample consists of <code>numPoints</code>
	 *  points, distributed evenly over <code>xRange</code>.
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel createModel(String name, Polynomial polynomial, <any> xRange, int numPoints) {
	}

	/**
	 *  Create a ChartModel by sampling from the supplied polynomial. The sampling points are given by the <code>xs</code>
	 *  array.
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel createModel(String name, Polynomial polynomial, Double[] xs) {
	}

	/**
	 *  Not supported
	 */
	public Polynomial performRegression(java.util.List points) {
	}
}
