/**
 *  Contains classes to support interpolation of chart models, either for aesthetics or for better approximations of functions.
 */
package com.jidesoft.chart.fit;


/**
 *  A class that fits a quadratic polynomial curve to a set of points contained in a ChartModel
 */
public class QuadraticFitter implements CurveFitter {

	/**
	 *  Returns an instance of a QuadraticFitter. If an instance has already been created then it is returned.
	 *  @return an instance of a QuadraticFitter
	 */
	public static QuadraticFitter getInstance() {
	}

	/**
	 *  Start by creating a RealMatrix to store the coefficients double[][] coefficientsData = {{2, 3, -2}, {-1, 7, 6},
	 *  {4, -3, -5}}; RealMatrix coefficients = new RealMatrixImpl(coefficientsData);
	 *  <p/>
	 *  Next create a double[] array to represent the constant vector and use solve(double[]) to solve the system
	 *  double[] constants = {1, -2, 1}; double[] solution = coefficients.solve(constants);
	 * 
	 *  @param model the chart model over which to perform the regression
	 *  @return a Polynomial as the result of the regression
	 */
	public Polynomial performRegression(com.jidesoft.chart.model.ChartModel model) {
	}

	public com.jidesoft.chart.model.DefaultChartModel createModel(Polynomial polynomial, <any> xRange, int numPoints) {
	}

	/**
	 *  Sometimes you want a generated model to have exactly the same coordinates on the x axis as the original model. If
	 *  you pass in the coordinates as xs here, this method returns such a model.
	 * 
	 *  @param name       the name of the model to be generated
	 *  @param polynomial the polynomial of the curve
	 *  @param xs         the x coordinates in the resulting ChartModel
	 *  @return the generated ChartModel
	 */
	public com.jidesoft.chart.model.AnnotatedChartModel createModel(String name, Polynomial polynomial, Double[] xs) {
	}

	public com.jidesoft.chart.model.DefaultChartModel createModel(String name, Polynomial polynomial, <any> xRange, int numPoints) {
	}

	public com.jidesoft.chart.model.AnnotatedChartModel performRegression(String name, com.jidesoft.chart.model.ChartModel model, <any> xRange, int numPoints) {
	}
}
