/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  An abstract superclass that implements many of the methods necessary in a delegating ChartModel.
 */
public abstract class AbstractDelegatingChartModel implements AnnotatedChartModel, ChartModelListener {

	public AbstractDelegatingChartModel() {
	}

	public AbstractDelegatingChartModel(ChartModel[] delegates) {
	}

	public AbstractDelegatingChartModel(java.util.Collection delegates) {
	}

	protected void init() {
	}

	public abstract int getAnnotationCount() {
	}

	public abstract com.jidesoft.chart.annotation.Annotation getAnnotation(int n) {
	}

	public abstract Chartable getPoint(int n) {
	}

	public abstract int getPointCount() {
	}

	protected abstract void update() {
	}

	/**
	 *  Returns the name of the model.
	 *  @return the name of the model
	 */
	public String getName() {
	}

	/**
	 *  Sets the name of the model instance to the supplied string.
	 *  <p>Note that you should not change the name of
	 *  a ChartModel after it has already been added to a Chart, as the name is used to identify the instance.</p>
	 *  @param name the name of the model instance
	 */
	public void setName(String name) {
	}

	public AnnotatedChartModel getDelegate() {
	}

	public AnnotatedChartModel getDelegate(int i) {
	}

	public AnnotatedChartModel[] getDelegates() {
	}

	public void setDelegate(ChartModel chartModel) {
	}

	public void setDelegates(java.util.Collection chartModels, boolean wireListeners) {
	}

	public void setDelegates(ChartModel[] chartModels) {
	}

	/**
	 *  Cyclical models are quite rare so we return a value of false here as a default. Subclasses can override this
	 *  if appropriate.
	 */
	public boolean isCyclical() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void addChartModelListener(ChartModelListener listener) {
	}

	/**
	 *  {@inheritDoc}
	 *  @param listener the listener that will no longer receive events
	 */
	public void removeChartModelListener(ChartModelListener listener) {
	}

	/**
	 *  Notify registered listeners that the chart model has changed
	 */
	protected void fireModelChanged() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void chartModelChanged() {
	}

	public java.util.Iterator iterator() {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}
}
