/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  This interface supports the idea of annotating an object with multiple Annotations.
 *  Annotation is also an interface, used as a semantic tag, so this interface can be used flexibly for
 *  attaching information of different kinds to some host object.
 */
public interface AnnotationModel {

	/**
	 *  Returns the number of annotations
	 *  @return the number of annotations
	 */
	public int getAnnotationCount();

	/**
	 *  Gets the nth annotation.
	 * 
	 *  @param n the index.
	 *  @return the nth annotation
	 */
	public com.jidesoft.chart.annotation.Annotation getAnnotation(int n);

	/**
	 *  Use this method to discover whether annotations should be shown or hidden.
	 *  @return whether annotations should be shown
	 */
	public boolean isAnnotationsVisible();

	/**
	 *  Specify whether annotations should be shown
	 *  @param visible whether annotations should be shown
	 */
	public void setAnnotationsVisible(boolean visible);
}
