/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A value class used to indicate a range of values along an axis.
 *  (We can't use the word 'Range' in the name though, because it already has a specific meaning
 *  in terms of allowable values. This is different to an extent, which covers all values from
 *  the min to the max, rather than allowing one value in that range.)
 *  @author Simon White (swhite@catalysoft.com)
 */
public class AxisExtent implements Comparable {

	/**
	 *  Create an AxisExtent instance using the supplied minimum and maximum values
	 *  @param minimum the minimum value of the portion of the axis
	 *  @param maximum the maximum value of the portion of the axis
	 */
	public AxisExtent(int minimum, int maximum) {
	}

	/**
	 *  Create an AxisExtent instance using the supplied minimum and maximum values
	 *  @param minimum the minimum value of the portion of the axis
	 *  @param maximum the maximum value of the portion of the axis
	 */
	public AxisExtent(double minimum, double maximum) {
	}

	/**
	 *  Returns the minimum value of a portion of an axis
	 *  @return the minimum value of a portion of an axis
	 */
	public double getMin() {
	}

	/**
	 *  Returns the maximum value of a portion of an axis
	 *  @return the maximum value of a portion of an axis
	 */
	public double getMax() {
	}

	/**
	 *  Returns the size of a portion of the axis. The result of this call is guaranteed to be non-negative.
	 *  @return the size of a portion of the axis, computed as the maximum minus the minimum
	 *  (or 0 if max < min, which should not be the case anyway)
	 */
	public double size() {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}

	/**
	 *  Compares this AxisExtent to another AxisExtent object by looking at the
	 *  minimum value and, if equal, then the maximum value
	 */
	public int compareTo(AxisExtent other) {
	}
}
