/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  This is the main interface for the models supported by the Chart component.
 *  As a convenience to the user of this model, we extend <code>Iterable&lt;Chartable&gt;</code> so that the
 *  user can easily iterate over the chartable points that the model contains.
 *  @see com.jidesoft.chart.Chart#setModel(ChartModel)
 *  @see com.jidesoft.chart.Chart#addModel(ChartModel)
 */
public interface ChartModel extends com.jidesoft.chart.util.Named, Iterable {

	/**
	 *  The name of a ChartModel is important, as different chart models are assumed to have different names. 
	 *  If you're adding multiple models to a <code>Chart</code>, make sure they have different names.
	 * 
	 *  @return a distinct name for this data set
	 */
	public String getName();

	/**
	 *  Gets the n<sup>th</sup> point. The first point has index 0.
	 * 
	 *  @param n the index
	 *  @return the n<sup>th</sup> point in the <code>ChartModel</code>.
	 */
	public Chartable getPoint(int n);

	/**
	 *  Gets the number of points in the data set
	 *  @return the number of points
	 */
	public int getPointCount();

	/**
	 *  Should a line be drawn from the last to the first point?
	 * 
	 *  @return whether the model represents a cycle of values
	 */
	public boolean isCyclical();

	/**
	 *  Register the listener's interest in this chart model.
	 *  @param listener the listener that will receive events
	 */
	public void addChartModelListener(ChartModelListener listener);

	/**
	 *  De-register the listener's interest in this chart model.
	 *  @param listener the listener that will no longer receive events
	 */
	public void removeChartModelListener(ChartModelListener listener);
}
