/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  An event object to signify a change in a ChartModel
 *  @see ChartModelChangeListener
 */
public class ChartModelChangeEvent extends java.util.EventObject {

	/**
	 *  Create a ChartModelChangeEvent and indicate the index in the model at which the change occurred
	 *  @param source the ChartModel object that is the source of the change
	 *  @param index the index at which the change occurred
	 */
	public ChartModelChangeEvent(Object source, ChartModelChangeType changeType, int index) {
	}

	/**
	 *  Create a ChartModelChangeEvent and indicate the index in the model at which the change occurred
	 *  as well as the number of points affected.
	 *  @param source the ChartModel object that is the source of the change
	 *  @param index the index at which the change occurred
	 *  @param size the number of points affected by the change
	 */
	public ChartModelChangeEvent(Object source, ChartModelChangeType changeType, int index, int size) {
	}

	/**
	 *  The type of the change: Was it an insertion, deletion or modification?
	 *  @return the change type
	 */
	public ChartModelChangeType getChangeType() {
	}

	/**
	 *  Specify the type of the change
	 *  @param changeType the change type
	 */
	public void setChangeType(ChartModelChangeType changeType) {
	}

	/**
	 *  @return the index of the model where the change occurred (prior to the change).
	 *  By default this is set to 0.
	 */
	public int getIndex() {
	}

	/**
	 *  @return the number of points affected by the change; for example the number of points inserted or deleted.
	 *  By default this is set at 1.
	 */
	public int getSize() {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
