/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  An interface implemented by classes that need to receive notification when a ChartModel has changed.
 */
public interface ChartModelChangeListener extends ChartModelListener {

	/**
	 *  This method is called to inform the ChartModelChangeListener of an event that
	 *  changed the ChartModel to which the listener is attached.
	 *  @param changeEvent the ChartModelChangeEvent
	 */
	public void chartModelChanged(ChartModelChangeEvent changeEvent);
}
