/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  <p> This is a very simple interface that indicates a change of some kind in a chart model,
 *  without any indication of what the change is. If a chart object receives an event of this
 *  kind it will have to redraw the whole chart because it does not know whether points have
 *  been added or deleted. It will have to go back to the model and ask all those questions again.</p>
 *  <p>ChartModelChangeListener extends this interface by providing a more information-rich method
 *  about what has changed</p>
 *  @see ChartModelChangeListener
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface ChartModelListener {

	/**
	 *  Call-back method to notify the listener that the chart model has changed
	 */
	public void chartModelChanged();
}
