/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A chart point in user/domain coordinates. A ChartPoint can have a highlight associated with it. A
 *  highlight is a semantic tag that may be interpreted by a view component and may affect the rendering.
 * 
 *  @author swhite@catalysoft.com
 */
@javax.xml.bind.annotation.XmlRootElement
@javax.xml.bind.annotation.XmlSeeAlso(com.jidesoft.chart.model.RealPosition.class)
public class ChartPoint implements Chartable, com.jidesoft.chart.util.Nameable, Highlightable {

	/**
	 *  Creates a ChartPoint with x and y coordinates of 0.
	 */
	public ChartPoint() {
	}

	/**
	 *  Creates a ChartPoint with the supplied x and y coordinates
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 */
	public ChartPoint(double x, double y) {
	}

	/**
	 *  Creates a ChartPoint with the supplied x and y coordinates and with the supplied Highlight
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 *  @param h the Highlight
	 */
	public ChartPoint(double x, double y, Highlight h) {
	}

	/**
	 *  Creates a ChartPoint using the supplied Positionable objects to determine the x and y coordinates
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 */
	public ChartPoint(Positionable x, Positionable y) {
	}

	/**
	 *  Creates a ChartPoint using the supplied Positionable object for the x coordinate, and the double
	 *  value for the y coordinate
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 */
	public ChartPoint(Positionable x, double y) {
	}

	/**
	 *  Creates a ChartPoint using the supplied Positionable object for the x coordinate, and the double
	 *  value for the y coordinate, and also applying the supplied Highlight
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 *  @param h the Highlight
	 */
	public ChartPoint(Positionable x, double y, Highlight h) {
	}

	/**
	 *  Creates a ChartPoint using the supplied double for the x coordinate, and the Positionable
	 *  value for the y coordinate, and also applying the supplied Highlight
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 *  @param h the Highlight
	 */
	public ChartPoint(double x, Positionable y, Highlight h) {
	}

	/**
	 *  Creates a ChartPoint using the supplied double as the x coordinate and the Positionable as the y coordinate.
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 */
	public ChartPoint(double x, Positionable y) {
	}

	/**
	 *  Creates a ChartPoint using the supplied Positionables as the x and y coordinates, and applying the supplied
	 *  Highlight
	 *  @param x the x coordinate
	 *  @param y the y coordinate
	 *  @param h the Highlight
	 */
	public ChartPoint(Positionable x, Positionable y, Highlight h) {
	}

	/**
	 *  A copy constructor that creates a new ChartPoint instance from an existing ChartPoint. The new ChartPoint
	 *  instance has the same x and y positions as its source point, and the same Highlight too.
	 */
	public ChartPoint(ChartPoint source) {
	}

	/**
	 *  {@inheritDoc}
	 */
	@javax.xml.bind.annotation.XmlAttribute
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlPositionableAdapter.class)
	public Positionable getX() {
	}

	/**
	 *  {@inheritDoc}
	 */
	@javax.xml.bind.annotation.XmlAttribute
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlPositionableAdapter.class)
	public Positionable getY() {
	}

	/**
	 *  Sets the x coordinate
	 *  @param xPos the new value for the x coordinate
	 */
	public void setX(Positionable xPos) {
	}

	/**
	 *  Sets the y coordinate
	 *  @param yPos the new value for the y coordinate
	 */
	public void setY(Positionable yPos) {
	}

	/**
	 *  Returns the highlight applied to this chart point, if any
	 *  @return the highlight applied to this chart point, if any
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public Highlight getHighlight() {
	}

	/**
	 *  Is the highlight for this chart point the same as the supplied highlight?
	 *  If the supplied highlight is null, this always returns false.
	 *  @param h the highlight to test
	 *  @return true if the supplied highlight is the same as the result of getHighlight()
	 */
	public boolean isHighlight(Highlight h) {
	}

	/**
	 *  Sets the highlight associated with this chart point, if any
	 *  @param h the new highlight
	 */
	public void setHighlight(Highlight h) {
	}

	/**
	 *  Compares this chart point instance to another instance.
	 *  The comparison is based first on the value of the x coordinate, then on the value of the y coordinate.
	 */
	public int compareTo(Chartable other) {
	}

	/**
	 *  Returns the name of the ChartPoint instance
	 *  @return the name of the ChartPoint instance
	 */
	public String getName() {
	}

	/**
	 *  Specifies the name of the ChartPoint instance
	 *  @param name the name of the instance
	 */
	public void setName(String name) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
