/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A ChartPoint specialised for financial charts in which each point has an open, high, low and close value.
 *  The point is positioned along a time axis, and summarises the behaviour of the measured value over an interval. 
 */
public class ChartPointOHLC extends ChartPointND {

	/**
	 *  Create a point for a financial chart with open, high, low, close values associated with a time point 
	 *  that summarises behaviour over an interval.
	 *  @param timestamp the centre point along the x axis
	 *  @param interval the width of the interval in milliseconds
	 *  @param open the opening value
	 *  @param high the high value
	 *  @param low the low value
	 *  @param close the closing value
	 */
	public ChartPointOHLC(long timestamp, double interval, double open, double high, double low, double close) {
	}

	/**
	 *  Create a point for a financial chart with open, high, low, close values associated with a time point 
	 *  that summarises behaviour over an interval.
	 *  @param timestamp the centre point along the x axis
	 *  @param interval the width of the interval in milliseconds
	 *  @param open the opening value
	 *  @param high the high value
	 *  @param low the low value
	 *  @param close the closing value
	 */
	public ChartPointOHLC(java.util.Date timestamp, double interval, double open, double high, double low, double close) {
	}

	public double getOpen() {
	}

	public double getClose() {
	}

	public double getHigh() {
	}

	public double getLow() {
	}
}
