/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A Chartable class has a <code>getX()</code> and a <code>getY()</code> method that together lend an object to being
 *  chartable in a two-dimensional chart.
 *  <p>
 *  The comparison of Chartable points uses the x axis values, so that a natural sort results them being ordered in 
 *  ascending order.  
 *  </p>
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface Chartable extends Comparable {

	/**
	 *  Gets the x coordinate of the Chartable object
	 *  @return the x coordinate
	 */
	public Positionable getX();

	/**
	 *  Gets the y coordinate of the Chartable object
	 *  @return the y coordinate
	 */
	public Positionable getY();
}
