/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A chartable that also carries a value for the Z axis
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface ChartableND extends Chartable3D {

	/**
	 *  By convention,
	 *  <ul>
	 *    <li>Dimension 0 is X</li>
	 *    <li>Dimension 1 is Y</li>
	 *    <li>Dimension 2 is Z</li>
	 *  </ul>
	 *  @param dimension the index of the dimension of interest
	 *  @return the coordinate value in the specified dimension
	 */
	public Positionable get(int dimension);

	/**
	 *  Returns the dimensionality of the point; i.e., the number of dimensions that have been set with a value.
	 *  @return the number of dimensions of the point
	 */
	public int getDimensionCount();
}
