/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A ChartModel class that creates a copy of the delegate chart model and does not allow it to be altered.
 *  Useful for multi-threading.
 *  <p>
 *  This class also attempts to make sure that it gets a 'clean' copy of the original model, i.e.,
 *  that the model is not altered during the copying add. It does this in an optimistic fashion by going
 *  ahead with the copying and then checking whether the model changed during the copying add.
 *  </p>
 *  <p>Note that because of the copying that occurs during initialisation, this class is not the exact analogue
 *  of the Unmodifiable wrappers for the Collection classes. This class has the disadvantage that it does some
 *  copying during initialisation, but has the advantage that we can make stronger guarantees about the contents
 *  of the container afterwards (and without having to be worrying about leaking references to the mutable data
 *  structure underneath). An unmodifiable ChartModel may also be added in a future release.</p>
 */
public final class CopiedChartModel implements ChartModel {

	/**
	 *  Construct a new ChartModel as a copy of the supplied model. The copied model, once created, cannot have
	 *  any points added or removed, so is useful in a multi-threaded context. The points themselves are not copies
	 *  but references to the original Chartables.
	 *  @param delegate the ChartModel to copy.
	 */
	public CopiedChartModel(ChartModel delegate) {
	}

	/**
	 *  Enables the caller to enquire whether the copying add was error-free. It is deemed to be
	 *  error-free if no change events were received from the delegate during the construction of the instance.
	 *  @return whether the copy was created successfully (without changes occurring to the delegate)
	 */
	public boolean isErrorFree() {
	}

	/**
	 *  This method accepts a listener but in fact does nothing with it. It is a no-op method
	 *  because the model is immutable and therefore will never fire a change event.
	 */
	public void addChartModelListener(ChartModelListener listener) {
	}

	/**
	 *  This method is also a no-op method (see {@link #addChartModelListener(ChartModelListener)})
	 */
	public void removeChartModelListener(ChartModelListener listener) {
	}

	/**
	 *  Returns the name of the chart model.
	 *  @return the name of the chart model
	 */
	public String getName() {
	}

	/**
	 *  Returns the nth point of the model.
	 *  @return the nth point of the model.
	 */
	public Chartable getPoint(int n) {
	}

	/**
	 *  Returns the number of points in the model.
	 *  @return the number of points in the model.
	 */
	public int getPointCount() {
	}

	/**
	 *  Returns whether the model is cyclical. When the model is drawn with a line this has the effect
	 *  that a line is drawn from the last point back to the first.
	 *  @return whether the model is cyclical
	 */
	public boolean isCyclical() {
	}

	/**
	 *  Returns an iterator for the model, so the model can be used directly in an advanced for ... loop.
	 */
	public java.util.Iterator iterator() {
	}

	/**
	 *  Equality is based on the name of the chart model, so that this copy is considered equal to
	 *  the model from which it originated.
	 */
	@java.lang.Override
	public boolean equals(Object other) {
	}
}
