/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  This is really a semantic tag for a point style. Highlights are immutable instances that exist at the model level
 *  and are applied to ChartPoints.
 *  When painting the points, the highlight is translated to a PointStyle that is stored at the View level in the Chart
 *  class.
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.model.XmlHighlightAdapter.class)
public class Highlight implements java.io.Serializable {

	/**
	 *  @deprecated in favour of use of ListSelectionModel, which is separate from the data model
	 */
	public static final Highlight selected;

	/**
	 *  @deprecated in favour of use of rollover property on a Chart
	 */
	public static final Highlight rollover;

	public static final Highlight fill;

	/**
	 *  Constructs an instance of a Highlight from the supplied name
	 *  @param name the name of the Highlight
	 */
	public Highlight(String name) {
	}

	/**
	 *  Returns the name of the Highlight as a String
	 *  @return the name of the Highlight
	 */
	public String getName() {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	public String name() {
	}

	@java.lang.Override
	public String toString() {
	}
}
