/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  If points of a <code>ChartModel</code> implement the <code>Highlightable</code> interface then a 
 *  <code>ChartStyle</code> can be associated with those points that differ from the rest of the 
 *  points of the model. As the name suggests, this facility is provided as a mechanism to draw 
 *  attention to some points of a model that display some special semantic property. It is a very 
 *  general mechanism and the semantics are defined by the application, but as an example you
 *  might want to mark some points as being outliers (that perhaps are ignored for the
 *  purposes of calculating averages).
 *  
 *  @see Highlight
 */
public interface Highlightable {

	/**
	 *  @return the <code>Highlight</code> associated with this object, or null if there is no highlight
	 */
	public Highlight getHighlight();

	/**
	 *  Specify the highlight to be associated with this object
	 *  @param h the new highlight
	 */
	public void setHighlight(Highlight h);
}
