/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A minimal extension to the ChartModel interface that allows us to retrieve the double-valued coordinates of
 *  the points without having to construct new objects
 */
public interface LeanChartModel extends ChartModel {

	/**
	 *  Returns the x and y coordinates of the n<sup>th</sup> point
	 *  @param n the index of the point of interest
	 *  @return an array of doubles: the first element is the x coordinate and the second element is the y coordinate
	 */
	public double[] getPointPositions(int n);
}
