/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  The LeanMemoryChartModel is designed for cases where you have a large data set that is read-only. You cannot
 *  change the points of the model after you have created it. The internal representation of the points uses less
 *  memory than a conventional ChartModel such as a DefaultChartModel, which is why this class is well-suited
 *  to large data sets. This class is a good choice, for example, if you are retrieving data from a database
 *  for display purposes only.
 */
@com.jidesoft.chart.util.Immutable
public final class LeanMemoryChartModel implements LeanChartModel {

	/**
	 *  Constructs a ChartModel from a list of x, y double pairs
	 *  @param points a list of x, y double coordinates
	 */
	public LeanMemoryChartModel(java.util.List points) {
	}

	/**
	 *  Constructs a ChartModel from an array of x, y double pairs
	 *  @param points an array of x, y double coordinates
	 */
	public LeanMemoryChartModel(double[][] points) {
	}

	/**
	 *  Constructs a ChartModel from a list of x, y double pairs
	 *  @param name the name of the model
	 *  @param points a list of x, y double coordinates
	 */
	public LeanMemoryChartModel(String name, java.util.List points) {
	}

	/**
	 *  Constructs a ChartModel from an array of x, y double pairs
	 *  @param name the name of the model
	 *  @param points an array of x, y double coordinates
	 */
	public LeanMemoryChartModel(String name, double[][] points) {
	}

	protected void init() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public String getName() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public Chartable getPoint(int n) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public double[] getPointPositions(int n) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public int getPointCount() {
	}

	/**
	 *  Specify whether the chart model is cyclical. A cyclical chart model is one in which the first and last points
	 *  are 'next to' one another. So when points of the model are connected with lines, the first and last points of
	 *  a cyclical model will also be connected, whereas the same points of a model that is not cyclical will not be
	 *  connected.
	 *  @param cyclical a boolean to indicate whether the chart model is cyclical
	 */
	public void setCyclical(boolean cyclical) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public boolean isCyclical() {
	}

	protected void fireModelChanged() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void addChartModelListener(ChartModelListener listener) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void removeChartModelListener(ChartModelListener listener) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public java.util.Iterator iterator() {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}
}
