/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  <p>This class contains utility methods to convert a ChartModel (or arrays of point coordinates) into a GeneralPath
 *  that uses Bezier curves to connect the points.</p> <p>For example, the DifferenceMarker class makes use of the
 *  methods here when its <em>smooth</em> property is set to true. Here are screen shots showing the 'before' and 'after'
 *  states of applying LineSmoother methods to the DifferenceMarker.</p> <table> <tr> <th>Before</th> <th>After</th>
 *  </tr> <tr> <td><img src="doc-files/LineSmoother-1.png" alt="A DifferenceMarker before applying a LineSmoother"/></td>
 *  <td><img src="doc-files/LineSmoother-2.png" alt="The same DifferenceMarker after applying a LineSmoother"/></td>
 *  </tr> </table>
 */
public class LineSmoother {

	/**
	 *  Prepares a GeneralPath in pixel coordinates as a smooth path joining the points of the model
	 * 
	 *  @param chart      the chart containing the model
	 *  @param model      the chart model of interest
	 *  @param smoothness the smoothness of the line
	 *  @return a GeneralPath in pixel coordinates as a smooth path joining the points of the model
	 */
	public static java.awt.geom.GeneralPath preparePath(com.jidesoft.chart.Chart chart, ChartModel model, double smoothness) {
	}

	/**
	 *  Prepares a GeneralPath in pixel coordinates as a smooth path joining the points of the model
	 * 
	 *  @param chart        the chart containing the model
	 *  @param model        the chart model of interest
	 *  @param smoothness   the smoothness of the line
	 *  @param reverseOrder specify whether the order of the supplied model should be reversed when generating the curve
	 *  @return a GeneralPath in pixel coordinates as a smooth path joining the points of the model
	 */
	public static java.awt.geom.GeneralPath preparePath(com.jidesoft.chart.Chart chart, ChartModel model, double smoothness, boolean reverseOrder) {
	}

	/**
	 *  The input points must already be cyclic, so the last x,y pair is expected to be the same as the first
	 * 
	 *  @param chart      the chart for which the path is being prepared
	 *  @param xs         an array of the x points as pixel coordinates
	 *  @param ys         an array of the y points as pixel coordinates
	 *  @param smoothness the smoothness of the line
	 *  @return a smooth cyclic path connecting all the points
	 */
	@java.lang.SuppressWarnings("unchecked")
	public static java.awt.geom.GeneralPath prepareCyclicPath(com.jidesoft.chart.Chart chart, double[] xs, double[] ys, double smoothness) {
	}

	/**
	 *  Prepares a General Path that uses Bezier curves to visit the supplied points and join the curve segments
	 *  smoothly
	 * 
	 *  @param chart      the chart for which the path is being prepared (used for checking whether points are viewable)
	 *  @param xPoints    an array of the xPoints as pixel coordinates
	 *  @param yPoints    an array of the yPoints as pixel coordinates
	 *  @param smoothness the smoothness of the line joining the points
	 *  @return a GeneralPath
	 */
	@java.lang.SuppressWarnings("unchecked")
	public static java.awt.geom.GeneralPath preparePath(com.jidesoft.chart.Chart chart, double[] xPoints, double[] yPoints, double smoothness) {
	}
}
