/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  <p>A class to manage the transition ('morphing') from one ChartModel to another.</p>
 *  <p><b>Note:</b> This class is in Beta status and is subject to change.
 */
public class ModelMorpher {

	public static final String PROPERTY_MORPH_STARTED = "Morph Started";

	public static final String PROPERTY_MORPH_ENDED = "Morph Ended";

	public static final String PROPERTY_MORPH_MODELS = "Morph Models";

	/**
	 *  This constructor is provided mainly for Java Bean compatibility. If you use it, make sure you call
	 *  <code>setChart</code> to inform the object of the chart on which it operates.
	 */
	public ModelMorpher() {
	}

	/**
	 *  Create a ModelMorpher instance and inform it of the chart object containing the model to transform.
	 *  A default number of steps of 10 is used, with a delay of 40ms.
	 * 
	 *  @param chart the chart object containing the model of interest
	 */
	public ModelMorpher(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Create a ModelMorpher instance on the supplied <code>Chart</code>.
	 * 
	 *  @param chart    the chart object containing the model(s) to be transformed
	 *  @param numSteps the number of steps in a transition
	 *  @param delay    the delay between the steps, in milliseconds
	 */
	public ModelMorpher(com.jidesoft.chart.Chart chart, int numSteps, int delay) {
	}

	/**
	 *  Add a property change listener to this object. Property events are fired at the beginning and at the end of
	 *  a transition.
	 * 
	 *  @param listener the property change listener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove a property change listener from this object.
	 * 
	 *  @param listener the property change listener to remove
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Perform a transition from the sourceModel to the targetModel. The sourceModel uses the supplied sourceStyle,
	 *  and the targetModel has the supplied targetStyle. By supplying these styles, colors can be morphed as well as
	 *  positions.
	 * 
	 *  @param sourceModel the original position before the morph
	 *  @param sourceStyle the original ChartStyle before the morph
	 *  @param targetModel the end ChartModel, after the transition
	 *  @param targetStyle the end ChartStyle, after the transition
	 */
	public void morph(ChartModel sourceModel, com.jidesoft.chart.style.ChartStyle sourceStyle, ChartModel targetModel, com.jidesoft.chart.style.ChartStyle targetStyle) {
	}

	public void morph(ChartModel[] sourceModels, com.jidesoft.chart.style.ChartStyle[] sourceStyles, ChartModel[] targetModels, com.jidesoft.chart.style.ChartStyle[] targetStyles) {
	}

	/**
	 *  Perform a transition from the sourceModel to the targetModel. The sourceModel uses the supplied sourceStyle,
	 *  and the targetModel has the supplied targetStyle. By supplying these styles, colors can be morphed as well as
	 *  positions.
	 * 
	 *  @param sourceModel    the original position before the morph
	 *  @param sourceStyle    the original ChartStyle before the morph
	 *  @param selectionModel the selection model to use during the transition
	 *  @param targetModel    the end ChartModel, after the transition
	 *  @param targetStyle    the end ChartStyle, after the transition
	 */
	public void morph(ChartModel sourceModel, com.jidesoft.chart.style.ChartStyle sourceStyle, javax.swing.ListSelectionModel selectionModel, ChartModel targetModel, com.jidesoft.chart.style.ChartStyle targetStyle) {
	}

	public void morph(ChartModel[] sourceModels, com.jidesoft.chart.style.ChartStyle[] sourceStyles, javax.swing.ListSelectionModel[] selectionModels, ChartModel[] targetModels, com.jidesoft.chart.style.ChartStyle[] targetStyles) {
	}

	/**
	 *  Returns the chart object used by this class
	 * 
	 *  @return the chart object
	 */
	public com.jidesoft.chart.Chart getChart() {
	}

	/**
	 *  Specify the chart object to be used by this morpher
	 * 
	 *  @param chart the chart object
	 */
	public void setChart(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Returns the style of the chart prior to the transition
	 * 
	 *  @return the chart style before the transition
	 *  @deprecated this is unused and will be removed some time after 3.2.4
	 */
	public com.jidesoft.chart.style.ChartStyle getSourceStyle() {
	}

	/**
	 *  Specify the style of the chart prior to the transition
	 * 
	 *  @param sourceStyle the ChartStyle before the transition
	 *  @deprecated this is unused and will be removed some time after 3.2.4
	 */
	public void setSourceStyle(com.jidesoft.chart.style.ChartStyle sourceStyle) {
	}

	/**
	 *  Returns the style of the ChartModel at the end of the transition
	 * 
	 *  @return the chart style after the transition
	 *  @deprecated this is unused and will be removed some time after 3.2.4
	 */
	public com.jidesoft.chart.style.ChartStyle getTargetStyle() {
	}

	/**
	 *  Specify the chart style at the end of the transition
	 * 
	 *  @param targetStyle the chart style to use at the end of the transition
	 *  @deprecated this is unused and will be removed some time after 3.2.4
	 */
	public void setTargetStyle(com.jidesoft.chart.style.ChartStyle targetStyle) {
	}

	public boolean isAutoRepaint() {
	}

	public void setAutoRepaint(boolean autoRepaint) {
	}

	/**
	 *  Returns true if a morph is currently in progress
	 * 
	 *  @return a boolean to indicate whether a morph is in progress.
	 */
	public boolean isMorphing() {
	}

	/**
	 *  Creates an intermediate point to be used during the transition
	 * 
	 *  @param source   the source point
	 *  @param target   the corresponding target point
	 *  @param position the position on a scale from 0 (source) to 1 (target)
	 *  @return a Chartable point representing the given position during the transition
	 */
	protected Chartable createIntermediate(Chartable source, Chartable target, double position) {
	}

	/**
	 *  A class specialised for the transition task - it knows where it is moving from and where to,
	 *  as well as its current position. It could also be given a strategy of how to get there, so that
	 *  different points can use different strategies to get there.
	 */
	public static class TransitionPoint {


		/**
		 *  Create a new Transition Point
		 */
		public ModelMorpher.TransitionPoint() {
		}

		/**
		 *  Create a transition point using the supplied source and target points
		 * 
		 *  @param source the location of the point before the transition
		 *  @param target the location of the point after the transition
		 */
		public ModelMorpher.TransitionPoint(Chartable source, Chartable target) {
		}

		/**
		 *  Returns the point before the transition
		 * 
		 *  @return the point before the transition
		 */
		@java.lang.SuppressWarnings("unused")
		public Chartable getSource() {
		}

		/**
		 *  Specify the point before the transition
		 * 
		 *  @param source the point before the transition
		 */
		public void setSource(Chartable source) {
		}

		/**
		 *  Returns the point after the transition
		 * 
		 *  @return the point after the transition
		 */
		@java.lang.SuppressWarnings("unused")
		public Chartable getTarget() {
		}

		/**
		 *  Specify the point after the transition
		 * 
		 *  @param target the point after the transition
		 */
		public void setTarget(Chartable target) {
		}

		/**
		 *  Returns the position of the transition on a scale from 0 (source) to 1 (target)
		 * 
		 *  @return the position
		 */
		@java.lang.SuppressWarnings("unused")
		public double getPosition() {
		}

		/**
		 *  Specify the position of the transition on a scale from 0 (source) to 1 (target)
		 * 
		 *  @param position the position of the transition on a scale from 0 (source) to 1 (target)
		 */
		public void setPosition(double position) {
		}

		/**
		 *  Update the location of the point according to the position and using the source and
		 *  target locations.
		 */
		protected void update() {
		}
	}
}
