/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  <p>Sorts the points of a chart model in increasing order. Note that the underlying unsorted model remains
 *  unchanged, but this class presents a sorted wrapper for it so that, for example, an unordered scatter plot
 *  can be displayed as a line chart in which the line progresses left to right or top to bottom instead of
 *  a random squiggle.</p>
 *  <p>The class allows you to specify an orientation for the sort, which means whether the sort is based
 *  on the x or the y values. If the orientation is horizontal the sort order is based on the y values
 *  and if the orientation is vertical the sort order is based on the x values (to understand the orientation
 *  consider sorting the bars of a bar chart).</p>
 */
public class SortedChartModel extends AbstractDelegatingChartModel implements AnnotatedChartModel, ChartModelListener {

	/**
	 *  Create an empty SortedChartModel. You can set a delegate by calling the setDelegate() method
	 */
	public SortedChartModel() {
	}

	/**
	 *  Create a SortedChartModel as a ChartModel that wraps the delegate, and with the sort orientation
	 *  (x or y) defined by the orientation parameter.
	 *  @param delegate the ChartModel to be sorted
	 *  @param orientation the orientation of the sort; use vertical for x values and horizontal for y values.
	 */
	public SortedChartModel(ChartModel delegate, com.jidesoft.chart.Orientation orientation) {
	}

	/**
	 *  Create a SortedChartModel as a ChartModel that wraps the delegate, and with the sort orientation
	 *  (x or y) defined by the orientation parameter.
	 *  @param delegate the ChartModel to be sorted
	 *  @param orientation the orientation of the sort; use vertical for x values and horizontal for y values.
	 *  @param sortIncreasing Specify whether the sort should be for increasing or decreasing values
	 */
	public SortedChartModel(ChartModel delegate, com.jidesoft.chart.Orientation orientation, boolean sortIncreasing) {
	}

	/**
	 *  Returns the orientation of the sort - vertical for x values and horizontal for y values
	 *  @return the orientation of the sort
	 */
	public com.jidesoft.chart.Orientation getOrientation() {
	}

	/**
	 *  Specify the orientation of the sort
	 *  @param orientation whether the sort is on x or y values (vertical for x values and horizontal for y values)
	 */
	public void setOrientation(com.jidesoft.chart.Orientation orientation) {
	}

	/**
	 *  Specify the delegate model that is to be sorted
	 *  @param delegate the model that is to be sorted
	 */
	public void setDelegate(ChartModel delegate) {
	}

	/**
	 *  Returns a boolean to indicate whether the sort is increasing. If false, the sort order is decreasing.
	 *  @return a boolean to indicate whether the sort is increasing.
	 */
	public boolean isSortIncreasing() {
	}

	/**
	 *  Specify the order of the sort
	 *  @param sortIncreasing whether the sort is to increasing (true) or decreasing (false)
	 */
	public void setSortIncreasing(boolean sortIncreasing) {
	}

	/**
	 *  Forces a re-computation of the sort order and fires a change event.
	 */
	public void chartModelChanged() {
	}

	/**
	 *  Returns the index in the delegate model of the nth point of this model
	 *  @param n the index of the point in this model
	 *  @return the index of the same point in the underlying model
	 */
	public Integer getDelegateIndex(int n) {
	}

	/**
	 *  Recomputes the sort order
	 */
	@java.lang.Override
	public void update() {
	}

	/**
	 *  returns the name of the model
	 *  @return the name of the model
	 */
	public String getName() {
	}

	public void setName(String name) {
	}

	/**
	 *  Returns the Chartable object for the nth point of this model
	 *  @param n the index
	 *  @return the corresponding Chartable object
	 */
	public Chartable getPoint(int n) {
	}

	/**
	 *  Returns the number of points in the model
	 *  @return the number of points in the model
	 */
	public int getPointCount() {
	}

	/**
	 *  Returns whether the model is cyclical
	 *  @return whether the model is cyclical
	 */
	public boolean isCyclical() {
	}

	/**
	 *  Returns an iterator over all the points of the model
	 *  @return an Iterator over all the points of the model
	 */
	public java.util.Iterator iterator() {
	}

	/**
	 *  If the delegate is an AnnotatedChartModel then it is returned; if the delegate is a regular
	 *  ChartModel that does not implement the AnnotatedChartModel interface then null is returned
	 *  @return either the delegate AnnotatedChartModel, or null
	 */
	protected AnnotatedChartModel getAnnotatedDelegate() {
	}

	/**
	 *  Returns the n<sup>th</sup> annotation of the delegate, or null if not available
	 *  @param n the index.
	 *  @return the n<sup>th</sup> annotation of the delegate
	 */
	public com.jidesoft.chart.annotation.Annotation getAnnotation(int n) {
	}

	/**
	 *  Returns the number of annotations in the delegate
	 *  @return the number of annotations in the delegate
	 */
	public int getAnnotationCount() {
	}

	/**
	 *  Returns a boolean to indicate whether annotations are visible in the delegate
	 *  @return a boolean to indicate whether annotations are visible in the delegate
	 */
	public boolean isAnnotationsVisible() {
	}

	/**
	 *  Sets whether annotations are visible in the delegate (if applicable)
	 *  @param visible whether annotations should be shown
	 */
	public void setAnnotationsVisible(boolean visible) {
	}
}
