/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A chart model that gets its y values by summing the corresponding values of its delegate chart models.
 *  The delegate chart models should have the same number of points. Points with the same index will be summed.
 *  <p>The class assumes by default that you wish to sum the y values of the delegate models. If you wish to sum
 *  the x values instead for a horizontal bar chart, you must set the orientation of the SummingChartModel.
 *  (see the <code>setOrientation()</code> method).</p>
 */
public class SummingChartModel extends AbstractDelegatingChartModel implements RangeProvider {

	/**
	 *  Default Constructor
	 */
	public SummingChartModel() {
	}

	/**
	 *  Creates a ChartModel that sums values in the supplied models
	 * 
	 *  @param delegates the chart models that we wish to sum over
	 */
	public SummingChartModel(ChartModel[] delegates) {
	}

	public SummingChartModel(java.util.Collection delegates) {
	}

	/**
	 *  Creates a ChartModel that sums values in the supplied models
	 * 
	 *  @param modelName the name of the constructed model
	 *  @param delegates the chart models that we wish to sum over
	 */
	public SummingChartModel(String modelName, ChartModel[] delegates) {
	}

	public void clear() {
	}

	public boolean isConsiderDelegateRanges() {
	}

	/**
	 *  Suppose you have two delegate models for which an x coordinate in one of those models has a value
	 *  of 10 and the same x coordinate in the other model has a value of -10. Then the sum is clearly zero,
	 *  but what should be returned when asking for the y range of this model?
	 *  When considerDelegateRanges is true, then the y range is from -10 to 10, whereas when it is false, the
	 *  y range is from 0 to 0. By default it is true.
	 */
	public void setConsiderDelegateRanges(boolean considerDelegateRanges) {
	}

	/**
	 *  Currently unsupported, but may become supported in the future
	 */
	@java.lang.Override
	public com.jidesoft.chart.annotation.Annotation getAnnotation(int n) {
	}

	/**
	 *  Currently unsupported so always returns 0
	 */
	@java.lang.Override
	public int getAnnotationCount() {
	}

	public boolean isAnnotationsVisible() {
	}

	public void setAnnotationsVisible(boolean visible) {
	}

	/**
	 *  Returns the orientation in which the summing occurs (by default, vertical)
	 *  @return the orientation in which the summing occurs (by default, vertical)
	 */
	public com.jidesoft.chart.Orientation getOrientation() {
	}

	/**
	 *  Specify the direction in which the summing should occur.
	 *  By default, summing occurs in the vertical orientation which corresponds to the y axis.
	 *  @param orientation the orientation of the summing
	 */
	public void setOrientation(com.jidesoft.chart.Orientation orientation) {
	}

	/**
	 *  Returns the nth point in the model. The nth point in the model is computed by summing the nth points of all
	 *  the delegate models
	 *  @param n the index in the model
	 *  @return the nth point in the model
	 */
	@java.lang.Override
	public Chartable getPoint(int n) {
	}

	/**
	 *  Returns the number of points in the model
	 *  @return the number of points in the model
	 */
	@java.lang.Override
	public int getPointCount() {
	}

	/**
	 *  Returns the x range of the model (as a Numeric Range)
	 *  @return the x range of the model
	 */
	public <any> getXRange() {
	}

	public AggregatedRange getXRange(Positionable pos) {
	}

	/**
	 *  Returns the y range of the model (as a Numeric Range)
	 *  @return the y range of the model
	 */
	public <any> getYRange() {
	}

	public AggregatedRange getYRange(Positionable pos) {
	}

	protected Chartable createChartable(Positionable xPos, Positionable yPos) {
	}

	@java.lang.Override
	protected void update() {
	}
}
