/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  This class converts a table model to a chart model. You can specify the columns to use for the
 *  x and y axes respectively, with <code>setXColumn()</code> and <code>setYColumn()</code>.
 *  <p/>
 *  <p>As a table model doesn't contain highlight information,
 *  this class also provides a facility to store highlights for points. (These points are usually part of the ChartPoints
 *  rather than the ChartModel).</p>
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class TableToChartAdapter implements AnnotatedChartModel, javax.swing.event.TableModelListener {

	public static final String PROPERTY_X_COLUMN = "XColumn";

	public static final String PROPERTY_Y_COLUMN = "YColumn";

	/**
	 *  Construct a Chart Model from a TableModel using columns of the table model
	 * 
	 *  @param name     the name of the chart model (used to differentiate from other chart models)
	 *  @param delegate the underlying table model
	 */
	public TableToChartAdapter(String name, javax.swing.table.TableModel delegate) {
	}

	/**
	 *  Set the delegate table model for this chart model.
	 *  Also attaches this model as a listener to the table model. You can detach the chart model from the table model
	 *  by calling this method with either a different table model (and it will attach itself to that model instead) or null.
	 * 
	 *  @param tableModel the new delegate table model
	 */
	public void setDelegate(javax.swing.table.TableModel tableModel) {
	}

	/**
	 *  @return the underlying table model used as input to this chart model
	 */
	public javax.swing.table.TableModel getDelegate() {
	}

	/**
	 *  Add a listener to listen for changes in bound properties
	 * 
	 *  @param listener a property change listener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Add a highlight for the point with index n
	 * 
	 *  @param n the index of the point for which we are adding a highlight
	 *  @param h the highlight of the point
	 */
	public void addHighlight(int n, Highlight h) {
	}

	/**
	 *  Remove the highlight for the point with index n
	 * 
	 *  @param n the index of the point for which we are removing a highlight
	 */
	public void removeHighlight(int n) {
	}

	/**
	 *  The preferred method to set the row interval in the underlying table model.
	 *  This method is preferable over calling both <code>setMinRow()</code> and <code>setMaxRow()</code>
	 *  because it fires one event for two changes.
	 * 
	 *  @param from the (included) start row for the interval
	 *  @param to   the (included) end row for the interval
	 */
	public void setRowInterval(Integer from, Integer to) {
	}

	public Integer getMinRow() {
	}

	/**
	 *  Sets the minimum row index for the points of interest in the table model
	 * 
	 *  @param minRow the minimum row index in the table model
	 */
	public void setMinRow(Integer minRow) {
	}

	public Integer getMaxRow() {
	}

	/**
	 *  Sets the maximum row index for the points of interest in the table model
	 * 
	 *  @param maxRow the maximum row index in the table model
	 */
	public void setMaxRow(Integer maxRow) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public String getName() {
	}

	/**
	 *  @return the table model column index currently being used for the x axis in the chart model
	 */
	public int getXColumn() {
	}

	/**
	 *  Set the column to use for the x axis
	 * 
	 *  @param xColumn the column index in the delegate table model
	 */
	public void setXColumn(int xColumn) {
	}

	/**
	 *  @return the table model column index currently being used for the y axis in the chart model
	 */
	public int getYColumn() {
	}

	/**
	 *  Set the column to use for the y axis
	 * 
	 *  @param yColumn the column index in the delegate table model
	 */
	public void setYColumn(int yColumn) {
	}

	/**
	 *  @return the Range of values for the x axis. If this is a non-numerical column then a CategoryRange
	 *          is returned; otherwise a NumericRange is returned.
	 */
	public <any> getXRange() {
	}

	/**
	 *  @return the Range of values for the x axis. If this is a non-numerical column then a CategoryRange
	 *          is returned; otherwise a NumericRange is returned.
	 */
	public <any> getYRange() {
	}

	/**
	 *  Returns the nth point of the ChartModel by delegating down to the underlying TableModel.
	 *  If the underlying model contains null(s) for the x or y coordinates, these are carried through
	 *  to the Chartable that is returned by this method. This approach means that the user of this ChartModel can
	 *  make decisions about how to deal with nulls; such as replacing them with a default value that can be plotted for
	 *  example.
	 *  <p>
	 *  The delegate can supply any instance of Number, which includes Double and Integer, but also Float, BigDecimal,
	 *  BigInteger and others. Regardless of the return type, non-null values are converted to a double so there may be
	 *  the risk of loss of precision for some types. Make sure the values supplied by the delegate can be represented
	 *  by a double.
	 *  </p>
	 */
	@java.lang.SuppressWarnings("unchecked")
	public Chartable getPoint(int n) {
	}

	/**
	 *  {@inheritDoc}
	 *  <p>The rules for the point count are as follows:
	 *  <ul>
	 *  <li>if the delegate is null, the point count is zero;</li>
	 *  <li>if the minRow or maxRow is null, the point count is the row count of the delegate, i.e. all the rows of the table;</li>
	 *  <li>if the minRow or maxRow is less than zero, the point count is zero;</li>
	 *  <li>otherwise, the point count is maxRow - minRow + 1.
	 *  </ul>
	 *  </p>
	 */
	public int getPointCount() {
	}

	/**
	 *  @return false by default
	 */
	public boolean isCyclical() {
	}

	public void setCyclical(boolean cyclical) {
	}

	public int getAnnotationCount() {
	}

	public void clearAnnotations() {
	}

	public com.jidesoft.chart.annotation.Annotation getAnnotation(int n) {
	}

	public void addAnnotation(com.jidesoft.chart.annotation.Annotation dec) {
	}

	public void removeAnnotation(com.jidesoft.chart.annotation.Annotation dec) {
	}

	public boolean isAnnotationsVisible() {
	}

	public void setAnnotationsVisible(boolean visible) {
	}

	public void addChartModelListener(ChartModelListener listener) {
	}

	public void removeChartModelListener(ChartModelListener listener) {
	}

	public java.util.Iterator iterator() {
	}

	/**
	 *  Clear the cache of any points derived from the table model and notify
	 *  listeners that the model has changed.
	 */
	public void update() {
	}

	protected void fireModelChanged() {
	}

	/**
	 *  This method fires a chart model event to its listeners.
	 *  If the underlying table model has changed, then the chart model has changed too.
	 */
	public void tableChanged(javax.swing.event.TableModelEvent e) {
	}
}
