/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A Positionable class that makes it easy to create positions on a Time Axis.
 *  This class is to a Time Axis as the RealPosition class is to a Numeric Axis.
 */
public class TimePosition {

	/**
	 *  Creates a TimePosition using the current system time as the position.
	 */
	public TimePosition() {
	}

	/**
	 *  Creates a TimePosition using the supplied long value as the number of milliseconds since January 1st 1970
	 *  (as in java.util.Date.getTime())
	 *  @param timeInMillis the number of milliseconds since January 1st 1970 at 00:00am
	 */
	public TimePosition(long timeInMillis) {
	}

	/**
	 *  Creates a TimePosition using the supplied time string and DateFormat specification. If you need to specify
	 *  a particular TimeZone for your date, you can specify this on your DateFormat class.
	 * 
	 *  @param timeString the time, represented as a string in the supplied DateFormat
	 *  @param dateFormat the format of the supplied timeString
	 *  @throws ParseException if the time string cannot be parsed according to the supplied DateFormat
	 */
	public TimePosition(String timeString, java.text.DateFormat dateFormat) {
	}

	/**
	 *  The position of this instance; used for positioning along an axis in a chart.
	 *  @return the position of this instance
	 */
	public double position() {
	}

	/**
	 *  Returns a Date instance for the Time encapsulated by this TimePosition.
	 *  @return a Date instance for this time.
	 */
	public java.util.Date getTime() {
	}

	public int compareTo(Positionable o) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object o) {
	}

	public String toString() {
	}
}
