/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  A chart model that provides a general transformation mechanism. Note that every point is transformed, so this cannot
 *  be used for filtering. This could be used for example to translate the chart, or perhaps to modify the data values
 *  by, for example, showing the logarithm.
 *  <p/>
 *  The hooking up of listeners and receiving change events is handled by the super class
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class TransformingChartModel extends AbstractDelegatingChartModel implements Transform {

	public TransformingChartModel() {
	}

	public TransformingChartModel(AnnotatedChartModel delegate) {
	}

	/**
	 *  Assigns a default name to the instance during construction. The name is unique within this JVM.
	 */
	@java.lang.Override
	protected void init() {
	}

	public Transform getTransform() {
	}

	public void setTransform(Transform transform) {
	}

	@java.lang.Override
	public int getAnnotationCount() {
	}

	@java.lang.Override
	public com.jidesoft.chart.annotation.Annotation getAnnotation(int n) {
	}

	public boolean isAnnotationsVisible() {
	}

	public void setAnnotationsVisible(boolean visible) {
	}

	@java.lang.Override
	public Chartable getPoint(int n) {
	}

	@java.lang.Override
	public int getPointCount() {
	}

	@java.lang.Override
	protected void update() {
	}

	public Chartable transform(Chartable chartable) {
	}

	/**
	 *  TransformingChartModels that have the same delegate need to have different hash codes so that they are recognised
	 *  as being different. This implementation uses the name and the delegate to generate a hash code.
	 */
	@java.lang.Override
	public int hashCode() {
	}

	/**
	 *  The equality of a TransformingChartModel depends on its name
	 */
	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
