/**
 *  Contains models to support the Chart view (in a Model-View-Controller sense)
 */
package com.jidesoft.chart.model;


/**
 *  This class converts a waterfall model to a conventional chart model. A waterfall model is one in which
 *  the first and last points of the model are absolute values, whereas the (y) values in between are interpreted as
 *  differences, each y value being a difference from the previous y value.
 */
public class WaterfallModelAdapter extends AbstractDelegatingChartModel {

	public static final Highlight FIRST;

	public static final Highlight RISING;

	public static final Highlight FALLING;

	public static final Highlight LAST;

	/**
	 *  Constructs a conventional ChartModel out of a waterfall model.
	 *  @param waterfallModel a chart model in which the values are interpreted as waterfall values
	 */
	public WaterfallModelAdapter(ChartModel waterfallModel) {
	}

	/**
	 *  Updates the points of this model based on the points of its delegate model
	 */
	protected void update() {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public int getAnnotationCount() {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public com.jidesoft.chart.annotation.Annotation getAnnotation(int n) {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public boolean isAnnotationsVisible() {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public void setAnnotationsVisible(boolean visible) {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public Chartable getPoint(int n) {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public int getPointCount() {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public boolean isCyclical() {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.Override
	public java.util.Iterator iterator() {
	}
}
