/**
 *  When users have preferences for the visual appearance of their Chart,
 *  classes from this package can be used to acquire those settings.
 */
package com.jidesoft.chart.preference;


/**
 *  <p>A component for selecting a new line width for traces shown by a Chart component:
 *  <img style="vertical-align:middle" src="doc-files/LineWidthChooser-1.png" alt="LineWidthChooser screen shot"/>
 *  </p>
 *  <p>When the line width changes, the object saves the line width as a personal preference
 *  in the Java Preference framework and re-fires the event as a PropertyChangeEvent.</p>
 * 
 *  @see PreferenceConstants#PROPERTY_LINE_WIDTH
 */
public class LineWidthChooser extends javax.swing.JSpinner implements javax.swing.event.ChangeListener {

	/**
	 *  Zero argument constructor for creating a line width chooser.
	 */
	public LineWidthChooser() {
	}

	/**
	 *  Returns the current line width property value
	 * 
	 *  @return the width to use for a line
	 */
	public Integer getLineWidth() {
	}

	/**
	 *  Updates the GUI component with the given line width value
	 * 
	 *  @param lineWidth the line width value to use
	 */
	public void setLineWidth(Integer lineWidth) {
	}

	protected void init() {
	}

	/**
	 *  This method receives a ChangeEvent when the line width changes.
	 *  It saves the line width as a personal preference in the Java Preference framework
	 *  and re-fires the event as a PropertyChangeEvent.
	 * 
	 *  @param e a ChangeEvent generated by the GUI component
	 *  @see PreferenceConstants#PROPERTY_LINE_WIDTH
	 */
	public void stateChanged(javax.swing.event.ChangeEvent e) {
	}
}
