/**
 *  When users have preferences for the visual appearance of their Chart,
 *  classes from this package can be used to acquire those settings.
 */
package com.jidesoft.chart.preference;


/**
 *  <p>A component for selecting a new point type for points shown by a Chart:
 *  <img style="vertical-align: middle" src="doc-files/PointShapeChooser-1.png" alt="PointShapeChooser screen shot"/></p>
 *  <p>The component allows you to select from any of the shapes defined by the PointShape enum:
 *  <img style="vertical-align: top" src="doc-files/PointShapeChooser-2.png" alt="PointShape chooser choices"/></p>
 *  <p>(screen shot taken on Windows platform)</p>
 *  <p>Whenever the value changes, a Property Change Event is fired and a point shape preference is stored using
 *  the Java Preferences Framework.</p>
 * 
 *  @see PreferenceConstants#PROPERTY_POINT_SHAPE
 */
public class PointShapeChooser extends javax.swing.JComboBox {

	/**
	 *  Zero argument constructor for creating a JComboBox that allows the user to choose the shape of
	 *  points used in a chart.
	 */
	public PointShapeChooser() {
	}

	protected void init() {
	}

	/**
	 *  Returns the currently selected point shape
	 * 
	 *  @return the current point shape
	 */
	public com.jidesoft.chart.PointShape getPointShape() {
	}

	/**
	 *  Specify the current point shape. Updates the GUI component with the supplied value.
	 * 
	 *  @param pointShape the point shape to display in the GUI component
	 */
	public void setPointShape(com.jidesoft.chart.PointShape pointShape) {
	}
}
