/**
 *  When users have preferences for the visual appearance of their Chart,
 *  classes from this package can be used to acquire those settings.
 */
package com.jidesoft.chart.preference;


/**
 *  This component is used as a renderer in a JComboBox when selecting the point shape to use when configuring the
 *  appearance of a chart. This class is used by the PointShapeChooser and you probably don't need to use it directly.
 * 
 *  @see PointShapeChooser
 */
public class PointShapeLabel extends javax.swing.JComponent implements javax.swing.ListCellRenderer {

	/**
	 *  Zero argument constructor for the class
	 */
	public PointShapeLabel() {
	}

	/**
	 *  Create an instance of the class, using the supplied color as the color for the shapes.
	 * 
	 *  @param color the color to use for the shapes
	 */
	public PointShapeLabel(java.awt.Color color) {
	}

	protected void init() {
	}

	/**
	 *  Creates a ChartStyle used when rendering the point of the label.
	 * 
	 *  @return the ChartStyle
	 */
	protected com.jidesoft.chart.style.ChartStyle createStyle() {
	}

	/**
	 *  Returns the current shape that will be rendered
	 * 
	 *  @return the current point shape
	 */
	public com.jidesoft.chart.PointShape getShape() {
	}

	/**
	 *  Specify the current shape
	 * 
	 *  @param shape the current point shape
	 */
	public void setShape(com.jidesoft.chart.PointShape shape) {
	}

	/**
	 *  Specify whether the point shape is currently selected. The selection
	 *  affects the background during rendering
	 * 
	 *  @return whether the point shape is selected
	 */
	public boolean isSelected() {
	}

	/**
	 *  Specify whether the point shape is selected
	 * 
	 *  @param selected a boolean value to indicate whether the point shape is selected
	 */
	public void setSelected(boolean selected) {
	}

	@java.lang.Override
	public void paintComponent(java.awt.Graphics g) {
	}

	/**
	 *  This is the method of the ListCellRenderer interface.
	 * 
	 *  @see ListCellRenderer#getListCellRendererComponent
	 */
	public java.awt.Component getListCellRendererComponent(javax.swing.JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
	}
}
