/**
 *  When users have preferences for the visual appearance of their Chart,
 *  classes from this package can be used to acquire those settings.
 */
package com.jidesoft.chart.preference;


/**
 *  <p>A component for selecting a new size for data points shown by a Chart:
 *  <img style="vertical-align: middle" src="doc-files/PointSizeChooser-1.png" alt="PointSizeChooser Screenshot"/>
 *  </p>
 *  <p>Since version 2.9.5, you can now specify the allowable values by passing minimum, maximum and step values to the
 *  constructor (along with the initial value)</p>
 */
public class PointSizeChooser extends javax.swing.JSpinner implements javax.swing.event.ChangeListener {

	/**
	 *  Zero argument constructor for the PointSizeChooser
	 */
	public PointSizeChooser() {
	}

	/**
	 *  Create a PointSizeChooser using the supplied values to create the set of valid options for the point size.
	 * 
	 *  @param initialValue the initial value for the point size
	 *  @param minimum      the minimum value for the point size
	 *  @param maximum      the maximum value for the point size
	 *  @param step         the increment to apply between the minimum and maximum values
	 */
	public PointSizeChooser(int initialValue, int minimum, int maximum, int step) {
	}

	/**
	 *  Returns the current point size
	 * 
	 *  @return the current point size
	 */
	public Integer getPointSize() {
	}

	/**
	 *  Sets the current point size for the GUI component
	 * 
	 *  @param pointSize the new value for the point size property
	 */
	public void setPointSize(Integer pointSize) {
	}

	protected void init() {
	}

	/**
	 *  The method of the ChangeListener interface. This method is called whenever the point size changes. It saves
	 *  the point size as a personal preference using the Java Preferences framework and re-fires the event as a
	 *  PropertyChangeEvent.
	 * 
	 *  @param e the Change Event
	 *  @see PreferenceConstants#PROPERTY_POINT_SIZE
	 */
	public void stateChanged(javax.swing.event.ChangeEvent e) {
	}
}
