/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An abstract super-class that can be sub-classed to write a bar renderer.
 */
public abstract class AbstractBarRenderer extends AbstractRenderer implements BarRenderer {

	public AbstractBarRenderer() {
	}

	public java.awt.Color getDefaultBarColor() {
	}

	public void setDefaultBarColor(java.awt.Color defaultBarColor) {
	}

	public boolean isLabelsVisible() {
	}

	public void setLabelsVisible(boolean labelsVisible) {
	}

	public com.jidesoft.chart.style.LabelStyle getLabelStyle() {
	}

	public void setLabelStyle(com.jidesoft.chart.style.LabelStyle labelStyle) {
	}

	public PointLabeler getPointLabeler() {
	}

	/**
	 *  Calling this method allows you to specify exactly how you would like the labels for the bars to appear.
	 *  For example you can set up a formatting for numeric variables or, in general, generate any text that you like.
	 *  @param pointLabeler a function that maps a Chartable to a String to use as a label
	 */
	public void setPointLabeler(PointLabeler pointLabeler) {
	}

	/**
	 *  Returns a boolean value to indicate whether a bar with a zero height will be shown
	 *  @return a boolean value to indicate whether a bar with a zero height will be shown
	 */
	public boolean isZeroHeightBarsVisible() {
	}

	/**
	 *  Specify whether to show bars with a height of zero. Default value is false.
	 *  @param zeroHeightBarsVisible boolean to indicate whether bars of zero height should be visible (with a line
	 *  or flat plane in the case of a 3D rendering).
	 */
	public void setZeroHeightBarsVisible(boolean zeroHeightBarsVisible) {
	}

	protected void renderBarLabel(java.awt.Graphics2D g2d, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable p, boolean isSelected, boolean hasRollover, boolean hasFocus, double x, double y, double width, double height) {
	}

	protected String computeLabel(com.jidesoft.chart.model.Chartable chartable) {
	}

	/**
	 *  You can override this method to create a custom Paint that uses the dimensions of the bar. For example,
	 *  you can create a gradient fill that always ranges from, say, red to yellow, regardless of the height of the bar.
	 */
	protected java.awt.Paint createBarPaint(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.Chartable p, com.jidesoft.chart.style.ChartStyle style, boolean isSelected, boolean hasRollover, boolean hasFocus, int x, int y, int width, int height) {
	}

	protected java.awt.Paint getBarColor(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.Chartable p, com.jidesoft.chart.style.ChartStyle style, boolean isSelected, boolean hasRollover, boolean hasFocus) {
	}
}
