/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An abstract superclass for line renderers
 */
public abstract class AbstractLineRenderer implements LineRenderer {

	public AbstractLineRenderer() {
	}

	/**
	 *  This returns the lineFill specified in the ChartStyle, but can be overridden to return, for example,
	 *  a gradient fill that depends on the height of the area that is to be filled.
	 *  <p>If you override this method, be sure that the ChartStyle still has a value for the lineFill property
	 *  as this is used as a trigger to determine whether the lineFill is to be used. So a value needs to be
	 *  provided even though it may be overridden and not used.</p>
	 */
	protected java.awt.Paint createLineFillPaint(com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.style.ChartStyle style, int x, int y, int width, int height) {
	}

	/**
	 *  Calculates the place on the y axis to which we fill the line
	 *  @param chart the chart
	 *  @param m the model we are filling
	 *  @param extent the logical name for the extent of the fill
	 *  @return a y pixel coordinate for the extent of the fill
	 */
	protected float calculateYVerticalExtent(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.style.LineFillExtent extent) {
	}

	protected float calculateXHorizontalExtent(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.style.LineFillExtent extent) {
	}
}
