/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An abstract class intended to be the super-class of all PieLabelRenderers.
 *  The idea is to make sure that all PieLabelRenderers provide the same set of
 *  methods for customising the label text color, font etc.
 *  @see SimplePieLabelRenderer
 *  @see LinePieLabelRenderer
 */
public abstract class AbstractPieLabelRenderer implements PieLabelRenderer {

	protected AbstractPieLabelRenderer() {
	}

	public java.awt.Color getLabelColor() {
	}

	public void setLabelColor(java.awt.Color labelColor) {
	}

	public java.awt.Font getLabelFont() {
	}

	public void setLabelFont(java.awt.Font labelFont) {
	}
}
