/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  The abstract pie segment renderer provides a method that renders labels that can be reused across different segment
 *  renderers.
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public abstract class AbstractPieSegmentRenderer extends AbstractRenderer implements PieSegmentRenderer {

	public static final String PROPERTY_ALWAYS_SHOW_OUTLINES = "Always Show Outlines";

	public static final String PROPERTY_PIE_LABEL_RENDERER = "Pie Label Renderer";

	public static final String PROPERTY_POINT_LABELER = "Point Labeler";

	public static final String PROPERTY_TICK_LENGTH = "Tick Length";

	public static final double maxExplode = 0.2;

	/**
	 *  Constructor.
	 *  Switches the property alwaysShowOutlines on as a default
	 */
	public AbstractPieSegmentRenderer() {
	}

	/**
	 *  Clear the cache of rendered shapes
	 */
	public void clearShapes() {
	}

	protected void recordSegment(java.awt.Shape shape, com.jidesoft.chart.event.PointDescriptor source) {
	}

	public java.awt.Graphics getLabelGraphics() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void setLabelGraphics(java.awt.Graphics g) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public int getTickLength() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void setTickLength(int tickLength) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public PointLabeler getPointLabeler() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void setPointLabeler(PointLabeler pointLabeler) {
	}

	public PieLabelRenderer getPieLabelRenderer() {
	}

	public void setPieLabelRenderer(PieLabelRenderer newLabelRenderer) {
	}

	/**
	 *  You can override this method to create a custom Paint that uses the dimensions of the pie segment
	 */
	protected java.awt.Paint createSegmentPaint(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.Chartable p, com.jidesoft.chart.style.ChartStyle style, boolean isSelected, boolean hasRollover, java.awt.Shape shape) {
	}

	/**
	 *  Render the labels of the specified ChartModel on to the Chart using the given Graphics context 
	 */
	public void renderLabels(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.Point center, int width, int height, int[] angles, com.jidesoft.chart.style.ChartStyle style) {
	}

	/**
	 *  Finds the segment of the pie chart that contains the point (x, y) if any. If none is found, the method returns
	 *  null
	 * 
	 *  @param p the point in pixel coordinates
	 *  @return the chartable for the containing segment, or null if none is found.
	 */
	public com.jidesoft.chart.event.PointDescriptor containingSegment(java.awt.Point p) {
	}

	/**
	 *  The PointDescriptor is a representation of the point in the model
	 *  @param c the point in the model
	 *  @return a description of the on-screen representation
	 */
	public com.jidesoft.chart.event.PointDescriptor rendered(com.jidesoft.chart.model.Chartable c) {
	}

	/**
	 *  Render the outlines of segments for a circular renderer
	 * 
	 *  @param g2d      the graphics context
	 *  @param chart    the chart component
	 *  @param model    the model for which the angles have been calculated
	 *  @param center   the centre of the chart
	 *  @param radius   the radius of the chart
	 *  @param angles   the consecutive (extent) angles of the segments
	 *  @param style    the suggested style to use for rendering the segments
	 */
	protected void renderOutlines(boolean isForSelection, java.awt.Graphics2D g2d, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.Point center, int radius, int[] angles, com.jidesoft.chart.style.ChartStyle style) {
	}

	protected void renderOutlines2D(boolean isForSelection, java.awt.Graphics2D g2d, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.geom.Point2D center, float radius, float[] angles, com.jidesoft.chart.style.ChartStyle style) {
	}

	protected java.awt.TexturePaint modify(java.awt.TexturePaint p) {
	}
}
